/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.hbannotation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HbCascadeType implements Enumerator
{
    ALL(0, "ALL", "ALL"),
    PERSIST(1, "PERSIST", "PERSIST"),
    MERGE(2, "MERGE", "MERGE"),
    REMOVE(3, "REMOVE", "REMOVE"),
    REFRESH(4, "REFRESH", "REFRESH"),
    DELETE(5, "DELETE", "DELETE"),
    SAVE_UPDATE(6, "SAVE_UPDATE", "SAVE_UPDATE"),
    REPLICATE(7, "REPLICATE", "REPLICATE"),
    DELETE_ORPHAN(8, "DELETE_ORPHAN", "DELETE_ORPHAN"),
    LOCK(9, "LOCK", "LOCK"),
    EVICT(10, "EVICT", "EVICT");

    public static final int ALL_VALUE = 0;
    public static final int PERSIST_VALUE = 1;
    public static final int MERGE_VALUE = 2;
    public static final int REMOVE_VALUE = 3;
    public static final int REFRESH_VALUE = 4;
    public static final int DELETE_VALUE = 5;
    public static final int SAVE_UPDATE_VALUE = 6;
    public static final int REPLICATE_VALUE = 7;
    public static final int DELETE_ORPHAN_VALUE = 8;
    public static final int LOCK_VALUE = 9;
    public static final int EVICT_VALUE = 10;
    private static final HbCascadeType[] VALUES_ARRAY;
    public static final List<HbCascadeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new HbCascadeType[]{ALL, PERSIST, MERGE, REMOVE, REFRESH, DELETE, SAVE_UPDATE, REPLICATE, DELETE_ORPHAN, LOCK, EVICT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static HbCascadeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HbCascadeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HbCascadeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HbCascadeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HbCascadeType get(int value) {
        switch (value) {
            case 0: {
                return ALL;
            }
            case 1: {
                return PERSIST;
            }
            case 2: {
                return MERGE;
            }
            case 3: {
                return REMOVE;
            }
            case 4: {
                return REFRESH;
            }
            case 5: {
                return DELETE;
            }
            case 6: {
                return SAVE_UPDATE;
            }
            case 7: {
                return REPLICATE;
            }
            case 8: {
                return DELETE_ORPHAN;
            }
            case 9: {
                return LOCK;
            }
            case 10: {
                return EVICT;
            }
        }
        return null;
    }

    private HbCascadeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

