/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.samples;

import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.emf.ecore.EPackage;

public final class SamplesSource {
    private static final String SOURCE_REL_PATH = "../src";
    private static File SAMPLES_SOURCE_BASE = null;

    private SamplesSource() {
    }

    public static String getOutputDirectory(String name, boolean isPackage) {
        File file = new File(SamplesSource.class.getResource(String.valueOf('/') + SamplesSource.class.getName().replace('.', '/') + ".class").getFile());
        file = file.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile();
        String path = name.replace('.', File.separatorChar);
        if (!isPackage) {
            path = path.substring(0, path.lastIndexOf(File.separatorChar));
        }
        file = new File(file, path);
        return file.getAbsolutePath();
    }

    public static File getSourceDirectory(String packageName) throws FileNotFoundException {
        File baseDir;
        if (SAMPLES_SOURCE_BASE == null) {
            File thisClassFile;
            String[] classCompNames = SamplesSource.class.getName().split("\\.");
            File baseDir2 = thisClassFile = new File(SamplesSource.class.getResource(String.valueOf(classCompNames[classCompNames.length - 1]) + ".class").getFile());
            int i = 0;
            while (i < classCompNames.length) {
                baseDir2 = baseDir2.getParentFile();
                ++i;
            }
            SAMPLES_SOURCE_BASE = new File(baseDir2, SOURCE_REL_PATH);
        }
        if (!(baseDir = new File(SAMPLES_SOURCE_BASE, packageName.replace('.', File.separatorChar))).exists()) {
            throw new FileNotFoundException("Directory " + baseDir.getAbsolutePath() + " does not exists");
        }
        return baseDir;
    }

    public static File[] getSourceDirectory(String[] packageNames) throws FileNotFoundException {
        File[] sourceFiles = new File[packageNames.length];
        int i = 0;
        while (i < packageNames.length) {
            sourceFiles[i] = SamplesSource.getSourceDirectory(packageNames[i]);
            ++i;
        }
        return sourceFiles;
    }

    private static String getEPackageFolder(EPackage ePackage) throws FileNotFoundException {
        int implPkgFinishAt;
        String implPackageName = ePackage.getClass().getName();
        if (implPackageName.substring(0, implPkgFinishAt = implPackageName.lastIndexOf(46)).endsWith(".impl")) {
            return implPackageName.substring(0, implPkgFinishAt - 5);
        }
        throw new FileNotFoundException("Could not find implementation package " + implPackageName.substring(0, implPkgFinishAt));
    }

    public static File getSourceDirectory(EPackage ePackage) throws FileNotFoundException {
        return SamplesSource.getSourceDirectory(SamplesSource.getEPackageFolder(ePackage));
    }

    public static File[] getSourceDirectory(EPackage[] ePackages) throws FileNotFoundException {
        File[] sourceFiles = new File[ePackages.length];
        int i = 0;
        while (i < ePackages.length) {
            sourceFiles[i] = SamplesSource.getSourceDirectory(ePackages[i]);
            ++i;
        }
        return sourceFiles;
    }
}

