/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapper;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pannotation.CascadeType;
import org.eclipse.emf.teneo.annotations.pannotation.JoinColumn;
import org.eclipse.emf.teneo.annotations.pannotation.JoinTable;
import org.eclipse.emf.teneo.annotations.pannotation.ManyToMany;
import org.eclipse.emf.teneo.annotations.pannotation.PAnnotation;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.hbannotation.Filter;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEReference;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedETypeElement;
import org.eclipse.emf.teneo.hibernate.mapper.AbstractAssociationMapper;
import org.eclipse.emf.teneo.hibernate.mapper.MappingException;
import org.eclipse.emf.teneo.simpledom.Element;
import org.eclipse.emf.teneo.util.StoreUtil;

public class ManyToManyMapper
extends AbstractAssociationMapper
implements ExtensionPoint {
    private static final Log log = LogFactory.getLog(ManyToManyMapper.class);

    public void process(PAnnotatedEReference paReference) {
        PAnnotatedEReference aOpposite;
        boolean isMap;
        log.debug((Object)("Creating many-to-many for " + paReference));
        HbAnnotatedEReference hbReference = (HbAnnotatedEReference)paReference;
        EReference eref = paReference.getModelEReference();
        JoinTable jt = hbReference.getJoinTable();
        ManyToMany mtm = hbReference.getManyToMany();
        if (jt == null) {
            throw new MappingException("Jointable is mandatory " + StoreUtil.toString((EStructuralFeature)eref));
        }
        Element collElement = this.addCollectionElement(hbReference);
        if (hbReference.getImmutable() != null) {
            collElement.addAttribute("mutable", "false");
        }
        if (((HbAnnotatedEReference)paReference).getHbCache() != null) {
            this.addCacheElement(collElement, ((HbAnnotatedEReference)paReference).getHbCache());
        }
        Element keyElement = collElement.addElement("key");
        this.handleOndelete(keyElement, hbReference.getHbOnDelete());
        boolean bl = isMap = StoreUtil.isMap((EStructuralFeature)eref) && this.getHbmContext().isMapEMapAsTrueMap();
        if (mtm.isIndexed() && hbReference.getHbIdBag() == null) {
            if (hbReference.getMapKey() != null || hbReference.getHbMapKey() != null || hbReference.getMapKeyManyToMany() != null) {
                this.addMapKey(collElement, paReference);
            } else if (isMap) {
                this.addMapKey(collElement, hbReference);
            } else {
                this.addListIndex(collElement, hbReference);
            }
        }
        this.addFetchType(collElement, mtm.getFetch());
        this.addCascades(collElement, this.getCascades(hbReference.getHbCascade(), (List<CascadeType>)mtm.getCascade(), false), false);
        PAnnotatedEClass referedToAClass = hbReference.getAReferenceType();
        String targetName = mtm.getTargetEntity();
        if (targetName == null) {
            targetName = this.getHbmContext().getEntityName(hbReference.getEReferenceType());
        }
        log.debug((Object)("Target entity-name " + targetName));
        Element mtmElement = referedToAClass.isOnlyMapAsEntity() || !this.getHbmContext().forceUseOfInstance(referedToAClass) ? collElement.addElement("many-to-many").addAttribute("entity-name", targetName).addAttribute("unique", "false") : collElement.addElement("many-to-many").addAttribute("class", this.getHbmContext().getInstanceClassName(hbReference.getEReferenceType())).addAttribute("unique", "false");
        if (hbReference.getNotFound() != null) {
            mtmElement.addAttribute("not-found", hbReference.getNotFound().getAction().getName().toLowerCase());
        }
        this.addForeignKeyAttribute(mtmElement, hbReference);
        if (!mtm.isIndexed() && hbReference.getHbIdBag() == null && mtm.getMappedBy() != null) {
            collElement.addAttribute("inverse", "true");
        } else if (mtm.getMappedBy() != null && mtm.isIndexed()) {
            log.warn((Object)"Indexed is true but indexed is not supported for inverse=true and many-to-many, not setting inverse=true");
        }
        if (hbReference.getModelEReference().getEOpposite() != null && (aOpposite = hbReference.getPaModel().getPAnnotated(hbReference.getModelEReference().getEOpposite())).getManyToMany() != null && aOpposite.getManyToMany().getMappedBy() != null && mtm.getMappedBy() != null) {
            log.error((Object)("Mappedby is set on both sides of the many-to-many relation, this does not work, see the efeature: " + hbReference.getModelElement().toString() + ". Ignoring the mappedby in this efeature"));
            mtm.setMappedBy(null);
        }
        this.addJoinTable(hbReference, collElement, keyElement, jt);
        if (jt.getInverseJoinColumns() != null) {
            for (JoinColumn joinColumn : jt.getInverseJoinColumns()) {
                mtmElement.addElement("column").addAttribute("name", this.getHbmContext().trunc((PAnnotation)joinColumn, joinColumn.getName())).addAttribute("not-null", joinColumn.isNullable() ? "false" : "true").addAttribute("unique", joinColumn.isUnique() ? "true" : "false");
            }
        }
        this.addAccessor(collElement);
        this.mapFilter(collElement, (List<Filter>)((HbAnnotatedETypeElement)paReference).getFilter());
    }
}

