/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.xml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEDataType;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEPackage;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.annotations.pannotation.PAnnotation;
import org.eclipse.emf.teneo.annotations.xml.ParseXMLAnnotationsException;
import org.eclipse.emf.teneo.annotations.xml.XmlElementToEStructuralFeatureMapper;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.extension.ExtensionManagerAware;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlPersistenceContentHandler
extends DefaultHandler
implements ExtensionPoint,
ExtensionManagerAware {
    private static final int ROOT = 0;
    private static final int PERSISTENCE_MAPPING = 1;
    private static final int EPACKAGE = 2;
    private static final int EPACKAGE_ANNOTATION = 3;
    private static final int ECLASS = 4;
    private static final int ECLASS_ANNOTATION = 5;
    private static final int ESTRUCTURALFEATURE = 6;
    private static final int ESTRUCTURALFEATURE_ANNOTATION = 7;
    private static final int NESTED_ANNOTATION = 8;
    private static final int ANNOTATION_ATTRIBUTE = 9;
    private static final int EDATATYPE = 10;
    private static final int EDATATYPE_ANNOTATION = 11;
    private static Pattern XML_NAME_PATTERN = Pattern.compile("-");
    private PAnnotatedModel pAnnotatedModel;
    private PAnnotatedEPackage pAnnotatedEPackage;
    private PAnnotatedEClass pAnnotatedEClass;
    private PAnnotatedEDataType pAnnotatedEDataType;
    private PAnnotatedEStructuralFeature pAnnotatedEStructuralFeature;
    private Stack<PAnnotation> pAnnotations = new Stack();
    private EAttribute pAnnotationEAttribute;
    private Stack<Integer> parseStates = new Stack();
    private String prefix;
    private ExtensionManager extensionManager;
    private XmlElementToEStructuralFeatureMapper xmlElementToEStructuralFeatureMapper;
    private EPackage.Registry ePackageRegistry = null;
    private boolean lenient = false;
    private String invalidElement = null;

    private static String convertXmlNameToEStructuralFeatureName(String xmlName) {
        String[] elementNameParts = XML_NAME_PATTERN.split(xmlName);
        StringBuffer featureName = new StringBuffer();
        int i = 0;
        while (i < elementNameParts.length) {
            String part = elementNameParts[i];
            if (i > 0) {
                part = String.valueOf(part.substring(0, 1).toUpperCase()) + part.substring(1);
            }
            featureName.append(part);
            ++i;
        }
        return featureName.toString();
    }

    public XmlPersistenceContentHandler() {
        this.parseStates.push(0);
    }

    public void setSchema(InputStream schema) {
        this.xmlElementToEStructuralFeatureMapper = this.getExtensionManager().getExtension(XmlElementToEStructuralFeatureMapper.class);
        this.xmlElementToEStructuralFeatureMapper.parseSchema(schema);
    }

    protected int getParseState() {
        assert (this.parseStates.size() >= 1) : "Parse state stack must contain at least one element.";
        return this.parseStates.peek();
    }

    protected PAnnotation getPAnnotation() {
        return this.pAnnotations.peek();
    }

    protected void applyAnnotation(EObject pAnnotatedEModelElement, String elementName, Attributes attributes) throws SAXException {
        EStructuralFeature annotationEStructuralFeature = this.getEStructuralFeature(pAnnotatedEModelElement, elementName);
        if (annotationEStructuralFeature == null) {
            throw new SAXException("Cannot handle element <" + elementName + ">");
        }
        PAnnotation pAnnotation = (PAnnotation)EcoreUtil.create((EClass)((EClass)annotationEStructuralFeature.getEType()));
        pAnnotation.setGenerated(false);
        this.pAnnotations.push(pAnnotation);
        if (annotationEStructuralFeature.isMany()) {
            ((List)pAnnotatedEModelElement.eGet(annotationEStructuralFeature)).add(pAnnotation);
        } else {
            pAnnotatedEModelElement.eSet(annotationEStructuralFeature, (Object)pAnnotation);
        }
        int i = 0;
        int n = attributes.getLength();
        while (i < n) {
            EAttribute eAttribute = (EAttribute)this.getEStructuralFeature((EObject)pAnnotation, attributes.getLocalName(i));
            EDataType eDataType = eAttribute.getEAttributeType();
            Object valueObject = eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, attributes.getValue(i));
            if (eAttribute.isMany()) {
                ((List)pAnnotation.eGet((EStructuralFeature)eAttribute)).add(valueObject);
            } else {
                pAnnotation.eSet((EStructuralFeature)eAttribute, valueObject);
            }
            ++i;
        }
    }

    protected EStructuralFeature getEStructuralFeature(EObject pAnnotatedEModelElement, String xmlName) {
        String annotationEStructuralFeatureName = XmlPersistenceContentHandler.convertXmlNameToEStructuralFeatureName(xmlName);
        EStructuralFeature annotationEStructuralFeature = pAnnotatedEModelElement.eClass().getEStructuralFeature(annotationEStructuralFeatureName);
        if (annotationEStructuralFeature == null) {
            annotationEStructuralFeatureName = this.xmlElementToEStructuralFeatureMapper.getEStructuralFeatureName(xmlName);
            annotationEStructuralFeature = pAnnotatedEModelElement.eClass().getEStructuralFeature(annotationEStructuralFeatureName);
        }
        if (annotationEStructuralFeature == null) {
            String name = XmlPersistenceContentHandler.convertXmlNameToEStructuralFeatureName(xmlName);
            annotationEStructuralFeatureName = String.valueOf(this.prefix) + name.substring(0, 1).toUpperCase() + name.substring(1);
            annotationEStructuralFeature = pAnnotatedEModelElement.eClass().getEStructuralFeature(annotationEStructuralFeatureName);
        }
        return annotationEStructuralFeature;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        int newParseState;
        if (this.invalidElement != null) {
            return;
        }
        switch (this.getParseState()) {
            case 0: {
                newParseState = 1;
                break;
            }
            case 1: {
                assert (localName.equals("epackage"));
                newParseState = 2;
                break;
            }
            case 2: {
                if (localName.equals("eclass")) {
                    newParseState = 4;
                    break;
                }
                if (localName.equals("edatatype")) {
                    newParseState = 10;
                    break;
                }
                newParseState = 3;
                break;
            }
            case 4: {
                if (localName.equals("eattribute") || localName.equals("ereference") || localName.equals("property")) {
                    newParseState = 6;
                    break;
                }
                newParseState = 5;
                break;
            }
            case 6: {
                newParseState = 7;
                break;
            }
            case 10: {
                newParseState = 11;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                EStructuralFeature annotationEStructuralFeature = this.getEStructuralFeature((EObject)this.getPAnnotation(), localName);
                if (annotationEStructuralFeature.getEType() instanceof EClass) {
                    newParseState = 8;
                    break;
                }
                newParseState = 9;
                break;
            }
            default: {
                throw new ParseXMLAnnotationsException("Invalid parse state encountered.");
            }
        }
        this.parseStates.push(new Integer(newParseState));
        switch (this.getParseState()) {
            case 2: {
                String namespaceUri = attributes.getValue("namespace-uri");
                EPackage ePackage = this.ePackageRegistry.getEPackage(namespaceUri);
                if (ePackage == null) {
                    throw new SAXException("Could not find EPackage \"" + namespaceUri + "\".");
                }
                this.pAnnotatedEPackage = this.pAnnotatedModel.getPAnnotated(ePackage);
                if (this.pAnnotatedEPackage != null) break;
                if (this.lenient) {
                    this.invalidElement = qName;
                    return;
                }
                throw new SAXException("Could not find PAnnotatedEPackage \"" + namespaceUri + "\".");
            }
            case 4: {
                String eClassName = attributes.getValue("name");
                EClassifier eClassifier = this.pAnnotatedEPackage.getModelEPackage().getEClassifier(eClassName);
                if (eClassifier == null) {
                    if (this.lenient) {
                        this.invalidElement = qName;
                        return;
                    }
                    throw new SAXException("Could not find EClass \"" + eClassName + "\"");
                }
                if (!(eClassifier instanceof EClass)) {
                    throw new SAXException("EClassifier \"" + eClassName + "\" is not an EClass.");
                }
                this.pAnnotatedEClass = this.pAnnotatedModel.getPAnnotated((EClass)eClassifier);
                break;
            }
            case 10: {
                String eDataTypeName = attributes.getValue("name");
                EDataType et = (EDataType)this.pAnnotatedEPackage.getModelEPackage().getEClassifier(eDataTypeName);
                if (et == null) {
                    if (this.lenient) {
                        this.invalidElement = qName;
                        return;
                    }
                    throw new SAXException("Could not find EDataType \"" + eDataTypeName + "\"");
                }
                this.pAnnotatedEDataType = this.pAnnotatedModel.getPAnnotated(et);
                break;
            }
            case 6: {
                String eStructuralFeatureName = attributes.getValue("name");
                EClass eClass = this.pAnnotatedEClass.getModelEClass();
                EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(eStructuralFeatureName);
                if (eStructuralFeature == null) {
                    if (this.lenient) {
                        this.invalidElement = qName;
                        return;
                    }
                    throw new SAXException("Could not find EStructuralFeature \"" + eStructuralFeatureName + "\" in EClass \"" + eClass.getName() + "\".");
                }
                if (localName.equals("eattribute") && !(eStructuralFeature instanceof EAttribute)) {
                    if (this.lenient) {
                        this.invalidElement = qName;
                        return;
                    }
                    throw new SAXException("EStructuralFeature \"" + eStructuralFeatureName + "\" in EClass \"" + eClass.getName() + "\" is not an EAttribute.");
                }
                if (localName.equals("ereference") && !(eStructuralFeature instanceof EReference)) {
                    if (this.lenient) {
                        this.invalidElement = qName;
                        return;
                    }
                    throw new SAXException("EStructuralFeature \"" + eStructuralFeatureName + "\" in EClass \"" + eClass.getName() + "\" is not an EReference.");
                }
                this.pAnnotatedEStructuralFeature = this.pAnnotatedModel.getPAnnotated(eStructuralFeature);
                break;
            }
            case 3: {
                this.applyAnnotation((EObject)this.pAnnotatedEPackage, localName, attributes);
                break;
            }
            case 5: {
                this.applyAnnotation((EObject)this.pAnnotatedEClass, localName, attributes);
                break;
            }
            case 7: {
                this.applyAnnotation((EObject)this.pAnnotatedEStructuralFeature, localName, attributes);
                break;
            }
            case 11: {
                this.applyAnnotation((EObject)this.pAnnotatedEDataType, localName, attributes);
                break;
            }
            case 8: {
                this.applyAnnotation((EObject)this.getPAnnotation(), localName, attributes);
                break;
            }
            case 9: {
                String eStructuralFeatureName = XmlPersistenceContentHandler.convertXmlNameToEStructuralFeatureName(localName);
                this.pAnnotationEAttribute = (EAttribute)this.getPAnnotation().eClass().getEStructuralFeature(eStructuralFeatureName);
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.invalidElement != null) {
            return;
        }
        String value = new String(ch, start, length).trim();
        if (value.length() == 0) {
            return;
        }
        switch (this.getParseState()) {
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                PAnnotation pAnnotation = this.getPAnnotation();
                assert (pAnnotation.eClass().getEStructuralFeatures().size() == 1);
                EAttribute eAttribute = (EAttribute)pAnnotation.eClass().getEStructuralFeatures().get(0);
                EDataType eAttributeType = eAttribute.getEAttributeType();
                Object valueObject = eAttributeType.getEPackage().getEFactoryInstance().createFromString(eAttributeType, value);
                if (eAttribute.isMany() && valueObject instanceof String) {
                    String[] vals = ((String)valueObject).split(",");
                    ArrayList<String> valsList = new ArrayList<String>();
                    String[] stringArray = vals;
                    int n = vals.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String val = stringArray[n2];
                        valsList.add(val);
                        ++n2;
                    }
                    pAnnotation.eSet((EStructuralFeature)eAttribute, valsList);
                    break;
                }
                pAnnotation.eSet((EStructuralFeature)eAttribute, valueObject);
                break;
            }
            case 9: {
                EDataType eDataType = this.pAnnotationEAttribute.getEAttributeType();
                Object valueObject = eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, value);
                if (this.pAnnotationEAttribute.isMany()) {
                    ((List)this.getPAnnotation().eGet((EStructuralFeature)this.pAnnotationEAttribute)).add(valueObject);
                    break;
                }
                this.getPAnnotation().eSet((EStructuralFeature)this.pAnnotationEAttribute, valueObject);
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.invalidElement != null) {
            if (this.invalidElement.equals(qName)) {
                this.invalidElement = null;
            }
            return;
        }
        switch (this.getParseState()) {
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                this.pAnnotations.pop();
                break;
            }
            case 9: {
                this.pAnnotationEAttribute = null;
            }
        }
        this.parseStates.pop();
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public PAnnotatedModel getPAnnotatedModel() {
        return this.pAnnotatedModel;
    }

    public void setPAnnotatedModel(PAnnotatedModel annotatedModel) {
        this.pAnnotatedModel = annotatedModel;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public EPackage.Registry getEPackageRegistry() {
        return this.ePackageRegistry;
    }

    public void setEPackageRegistry(EPackage.Registry ePackageRegistry) {
        this.ePackageRegistry = ePackageRegistry;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }
}

