/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapper;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.Column;
import org.eclipse.emf.teneo.annotations.pannotation.EnumType;
import org.eclipse.emf.teneo.annotations.pannotation.Enumerated;
import org.eclipse.emf.teneo.annotations.pannotation.External;
import org.eclipse.emf.teneo.annotations.pannotation.JoinColumn;
import org.eclipse.emf.teneo.annotations.pannotation.PannotationFactory;
import org.eclipse.emf.teneo.annotations.pannotation.TemporalType;
import org.eclipse.emf.teneo.hibernate.hbannotation.Any;
import org.eclipse.emf.teneo.hibernate.hbannotation.AnyMetaDef;
import org.eclipse.emf.teneo.hibernate.hbannotation.Cache;
import org.eclipse.emf.teneo.hibernate.hbannotation.Filter;
import org.eclipse.emf.teneo.hibernate.hbannotation.GenerationTime;
import org.eclipse.emf.teneo.hibernate.hbannotation.HbCascadeType;
import org.eclipse.emf.teneo.hibernate.hbannotation.HbannotationFactory;
import org.eclipse.emf.teneo.hibernate.hbannotation.Index;
import org.eclipse.emf.teneo.hibernate.hbannotation.OnDelete;
import org.eclipse.emf.teneo.hibernate.hbannotation.Parameter;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEAttribute;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEDataType;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEReference;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedETypeElement;
import org.eclipse.emf.teneo.hibernate.mapper.MappingContext;
import org.eclipse.emf.teneo.hibernate.mapper.MappingException;
import org.eclipse.emf.teneo.mapping.strategy.EntityNameStrategy;
import org.eclipse.emf.teneo.simpledom.Element;
import org.eclipse.emf.teneo.util.EcoreDataTypes;
import org.eclipse.emf.teneo.util.StoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMapper {
    private static final String[] TEMPORAL_TYPE_NAMES = new String[TemporalType.VALUES.size()];
    protected MappingContext hbmContext;

    static {
        AbstractMapper.TEMPORAL_TYPE_NAMES[TemporalType.DATE.getValue()] = "date";
        AbstractMapper.TEMPORAL_TYPE_NAMES[TemporalType.TIME.getValue()] = "time";
        AbstractMapper.TEMPORAL_TYPE_NAMES[TemporalType.TIMESTAMP.getValue()] = "timestamp";
    }

    private static String hbType(TemporalType temporalType) {
        return TEMPORAL_TYPE_NAMES[temporalType != null ? temporalType.getValue() : TemporalType.TIMESTAMP.getValue()];
    }

    protected PAnnotatedEReference getOtherSide(PAnnotatedEReference paReference) {
        if (paReference.getModelEReference().getEOpposite() == null) {
            return null;
        }
        return paReference.getPaModel().getPAnnotated(paReference.getModelEReference().getEOpposite());
    }

    protected MappingContext getHbmContext() {
        return this.hbmContext;
    }

    protected void setHbmContext(MappingContext hbmContext) {
        this.hbmContext = hbmContext;
    }

    protected void addAccessor(Element element, String propertyHandler) {
        if (propertyHandler != null && propertyHandler.length() > 0) {
            element.addAttribute("access", this.hbmContext.getPropertyHandlerName());
        }
    }

    protected void addAccessor(Element element) {
        this.addAccessor(element, this.hbmContext.getPropertyHandlerName());
    }

    protected void setType(PAnnotatedEStructuralFeature paFeature, Element propElement) {
        if (paFeature instanceof PAnnotatedEAttribute) {
            this.setType((PAnnotatedEAttribute)paFeature, propElement);
        } else {
            this.setType((PAnnotatedEReference)paFeature, propElement);
        }
    }

    protected void setType(PAnnotatedEReference paReference, Element propElement) {
        External external = paReference.getExternal();
        if (external == null) {
            throw new MappingException("External annotation not set on eReference " + StoreUtil.toString((EStructuralFeature)paReference.getModelEReference()));
        }
        Element typeElement = propElement.addElement("type");
        if (external.getType() == null) {
            typeElement.addAttribute("name", this.getHbmContext().getExternalUserType());
        } else {
            typeElement.addAttribute("name", external.getType());
        }
        typeElement.addElement("param").addAttribute("name", "eclassName").addText(paReference.getModelEReference().getEReferenceType().getName());
        typeElement.addElement("param").addAttribute("name", "epackage").addText(paReference.getModelEReference().getEReferenceType().getEPackage().getNsURI());
    }

    protected void setType(PAnnotatedEAttribute paAttribute, Element propElement) {
        EList<Parameter> params;
        String name;
        HbAnnotatedEAttribute hea = (HbAnnotatedEAttribute)paAttribute;
        EDataType ed = (EDataType)hea.getModelEAttribute().getEType();
        HbAnnotatedEDataType hed = (HbAnnotatedEDataType)hea.getPaModel().getPAnnotated(ed);
        if (hea.getHbType() != null) {
            name = hea.getHbType().getType();
            params = hea.getHbType().getParameters();
        } else if (hed != null && hed.getHbType() != null) {
            name = hed.getHbType().getType();
            params = hed.getHbType().getParameters();
        } else if (hed != null && hed.getHbTypeDef() != null) {
            name = hed.getHbTypeDef().getName();
            params = null;
        } else {
            name = null;
            params = null;
        }
        if (name != null) {
            if (params == null || params.isEmpty()) {
                propElement.addAttribute("type", name);
            } else {
                Element typeElement = propElement.addElement("type").addAttribute("name", name);
                for (Parameter param : params) {
                    typeElement.addElement("param").addAttribute("name", param.getName()).addText(param.getValue());
                }
            }
        } else if (paAttribute.getEnumerated() != null) {
            this.handleEnumType(paAttribute, propElement);
        } else if (StoreUtil.isQName((EAttribute)paAttribute.getModelEAttribute())) {
            propElement.addAttribute("type", "org.eclipse.emf.teneo.hibernate.mapping.QNameUserType");
        } else {
            String hType = this.hbType(paAttribute);
            if (hType != null) {
                propElement.addAttribute("type", hType);
            } else {
                Element typeElement = propElement.addElement("type").addAttribute("name", this.hbmContext.getDefaultUserType());
                typeElement.addElement("param").addAttribute("name", "edatatype").addText(paAttribute.getModelEAttribute().getEAttributeType().getName());
                typeElement.addElement("param").addAttribute("name", "epackage").addText(paAttribute.getModelEAttribute().getEType().getEPackage().getNsURI());
            }
        }
    }

    private void handleEnumType(PAnnotatedEAttribute paAttribute, Element propElement) {
        Enumerated enumerated = paAttribute.getEnumerated();
        assert (enumerated != null);
        EAttribute eattr = paAttribute.getModelEAttribute();
        EClassifier eclassifier = eattr.getEType();
        if (!this.getHbmContext().isGeneratedByEMF() && this.getHbmContext().getInstanceClass(eclassifier) != null) {
            Class<?> instanceClass = this.getHbmContext().getInstanceClass(eclassifier);
            Element typeElement = propElement.addElement("type").addAttribute("name", this.getEnumUserType(enumerated));
            typeElement.addElement("param").addAttribute("name", "enumClass").addText(instanceClass.getName());
            typeElement.addElement("param").addAttribute("name", "eclassifier").addText(eclassifier.getName());
            typeElement.addElement("param").addAttribute("name", "epackage").addText(eclassifier.getEPackage().getNsURI());
        } else if (this.getHbmContext().isGeneratedByEMF() && eclassifier.getInstanceClass() != null) {
            Element typeElement = propElement.addElement("type").addAttribute("name", this.getEnumUserType(enumerated));
            typeElement.addElement("param").addAttribute("name", "enumClass").addText(eclassifier.getInstanceClass().getName());
            typeElement.addElement("param").addAttribute("name", "eclassifier").addText(eclassifier.getName());
            typeElement.addElement("param").addAttribute("name", "epackage").addText(eclassifier.getEPackage().getNsURI());
        } else {
            Element typeElement = propElement.addElement("type").addAttribute("name", this.hbDynamicEnumType(enumerated));
            typeElement.addElement("param").addAttribute("name", "eclassifier").addText(eclassifier.getName());
            typeElement.addElement("param").addAttribute("name", "epackage").addText(eclassifier.getEPackage().getNsURI());
        }
    }

    protected List<PAnnotatedEStructuralFeature> getAllFeatures(PAnnotatedEClass componentAClass) {
        ArrayList<PAnnotatedEStructuralFeature> result = new ArrayList<PAnnotatedEStructuralFeature>();
        result.addAll((Collection<PAnnotatedEStructuralFeature>)componentAClass.getPaEStructuralFeatures());
        for (EClass eClass : componentAClass.getModelEClass().getESuperTypes()) {
            PAnnotatedEClass aSuperClass = componentAClass.getPaModel().getPAnnotated(eClass);
            if (aSuperClass == null) continue;
            result.addAll(this.getAllFeatures(aSuperClass));
        }
        return result;
    }

    protected String hbType(PAnnotatedEAttribute paAttribute) {
        EAttribute eAttribute = paAttribute.getModelEAttribute();
        HbAnnotatedEDataType hed = (HbAnnotatedEDataType)paAttribute.getPaModel().getPAnnotated(eAttribute.getEAttributeType());
        EDataType eDataType = paAttribute.getModelEAttribute().getEAttributeType();
        if (hed != null && hed.getHbTypeDef() != null) {
            return hed.getHbTypeDef().getName();
        }
        if (paAttribute.getLob() != null) {
            if (EcoreDataTypes.INSTANCE.isByteArray(eDataType)) {
                return "binary";
            }
            if (EcoreDataTypes.INSTANCE.isEString(eDataType)) {
                return "text";
            }
            throw new MappingException("Lob annotations can only be used with Strings or byte arrays. Attribute is of type: " + eDataType);
        }
        if (EcoreDataTypes.INSTANCE.isEWrapper(eDataType) || EcoreDataTypes.INSTANCE.isEPrimitive(eDataType)) {
            return eDataType.getInstanceClassName();
        }
        if (EcoreDataTypes.INSTANCE.isEString(eDataType)) {
            return eDataType.getInstanceClassName();
        }
        if (EcoreDataTypes.INSTANCE.isEDateTime(eDataType) || paAttribute.getTemporal() != null && paAttribute.getTemporal().getValue().getValue() == 2) {
            return this.getEDateTimeClass(paAttribute);
        }
        if (EcoreDataTypes.INSTANCE.isEDuration(eDataType)) {
            return this.hbmContext.getDurationType();
        }
        if (EcoreDataTypes.INSTANCE.isEDate(eDataType, this.getHbmContext().getPersistenceOptions()) || paAttribute.getTemporal() != null && paAttribute.getTemporal().getValue().getValue() == 0) {
            return this.getEDateClass(paAttribute);
        }
        if (eDataType.getInstanceClass() != null && eDataType.getInstanceClass() == Object.class) {
            return null;
        }
        String result = EcoreDataTypes.INSTANCE.getTargetTypeName(paAttribute);
        if (result.compareTo(Object.class.getName()) == 0) {
            return null;
        }
        return result;
    }

    protected String getTargetTypeName(PAnnotatedEAttribute aAttribute) {
        EAttribute eAttribute = aAttribute.getModelEAttribute();
        Class instanceClass = eAttribute.getEAttributeType().getInstanceClass();
        if (instanceClass != null && !Object.class.equals((Object)instanceClass) && !List.class.equals((Object)instanceClass)) {
            if (instanceClass.isArray()) {
                return eAttribute.getEType().getInstanceClassName().substring(0, eAttribute.getEType().getInstanceClassName().length() - 2);
            }
            return instanceClass.getName();
        }
        ArrayList eclassifiers = EcoreDataTypes.INSTANCE.getItemTypes((EDataType)eAttribute.getEType());
        if (eclassifiers.size() > 0) {
            StringBuffer result = new StringBuffer();
            int i = 0;
            while (i < eclassifiers.size()) {
                EClassifier eclassifier = (EClassifier)eclassifiers.get(i);
                if (i > 0) {
                    result.append(",");
                }
                result.append(eclassifier.getInstanceClassName());
                ++i;
            }
            return result.toString();
        }
        return Object.class.getName();
    }

    public String getEnumUserType(Enumerated enumerated) {
        if (EnumType.STRING == enumerated.getValue()) {
            return this.getHbmContext().getEnumUserType();
        }
        return this.getHbmContext().getEnumIntegerUserType();
    }

    protected String hbDynamicEnumType(Enumerated enumerated) {
        if (EnumType.STRING == enumerated.getValue()) {
            return this.getHbmContext().getDynamicEnumUserType();
        }
        return this.getHbmContext().getDynamicEnumIntegerUserType();
    }

    public String getEDateClass(PAnnotatedEAttribute paAttribute) {
        EDataType eDataType = paAttribute.getModelEAttribute().getEAttributeType();
        assert (EcoreDataTypes.INSTANCE.isEDate(eDataType, this.getHbmContext().getPersistenceOptions()));
        if (XMLTypePackage.eINSTANCE.getDate().equals(eDataType)) {
            return this.getHbmContext().getXSDDateUserType();
        }
        if (paAttribute.getTemporal() != null) {
            TemporalType tt = paAttribute.getTemporal().getValue();
            return AbstractMapper.hbType(tt);
        }
        if (EcoreDataTypes.INSTANCE.isEDate(eDataType, this.getHbmContext().getPersistenceOptions())) {
            return this.getHbmContext().getXSDDateUserType();
        }
        return Date.class.getName();
    }

    public String getEDateTimeClass(PAnnotatedEAttribute paAttribute) {
        EDataType eDataType = paAttribute.getModelEAttribute().getEAttributeType();
        assert (EcoreDataTypes.INSTANCE.isEDateTime(eDataType));
        if (XMLTypePackage.eINSTANCE.getDateTime().equals(eDataType)) {
            return this.getHbmContext().getXSDDateTimeUserType();
        }
        if (paAttribute.getTemporal() != null) {
            TemporalType tt = paAttribute.getTemporal().getValue();
            return AbstractMapper.hbType(tt);
        }
        if (eDataType.getInstanceClass() != null && Date.class.isAssignableFrom(eDataType.getInstanceClass())) {
            return eDataType.getInstanceClass().getName();
        }
        if (EcoreDataTypes.INSTANCE.isEDateTime(eDataType)) {
            return this.getHbmContext().getXSDDateTimeUserType();
        }
        return Timestamp.class.getName();
    }

    protected List<JoinColumn> getJoinColumns(PAnnotatedEReference paReference) {
        List joinColumns = this.getHbmContext().getAssociationOverrides(paReference);
        if (joinColumns == null) {
            return paReference.getJoinColumns();
        }
        if (joinColumns == null) {
            return new ArrayList<JoinColumn>();
        }
        return joinColumns;
    }

    protected void addCacheElement(Element parent, Cache cache) {
        String usage = cache.getUsage().getName().toLowerCase().replaceAll("_", "-");
        Element cacheElement = parent.addElement("cache").addAttribute("usage", usage);
        if (cache.getRegion() != null) {
            cacheElement.addAttribute("region", cache.getRegion());
        }
        if (cache.getInclude() != null) {
            cacheElement.addAttribute("include", cache.getInclude());
        }
        parent.remove(cacheElement);
        parent.add(0, cacheElement);
    }

    protected void addColumnsAndFormula(Element propertyElement, PAnnotatedEStructuralFeature pef, List<Column> columns, boolean isNullable, boolean setColumnAttributesInProperty) {
        this.addColumnsAndFormula(propertyElement, pef, columns, isNullable, setColumnAttributesInProperty, false, false);
    }

    protected void addColumnsAndFormula(Element propertyElement, PAnnotatedEStructuralFeature pef, List<Column> columns, boolean isNullable, boolean setColumnAttributesInProperty, boolean isUnique, boolean isIdProperty) {
        HbAnnotatedETypeElement hbFeature = (HbAnnotatedETypeElement)pef;
        if (columns.isEmpty() && hbFeature.getFormula() == null) {
            Column col = PannotationFactory.eINSTANCE.createColumn();
            col.setName(this.getColumnName(pef));
            col.setNullable(isNullable);
            if (isIdProperty) {
                col.setUnique(false);
            } else {
                col.setUnique(isUnique);
            }
            if (pef instanceof HbAnnotatedEAttribute && ((HbAnnotatedEAttribute)pef).getGenerated() != null && ((HbAnnotatedEAttribute)pef).getGenerated().getValue() != null && ((HbAnnotatedEAttribute)pef).getGenerated().getValue() != GenerationTime.NEVER) {
                col.setInsertable(false);
                col.setUpdatable(false);
            }
            columns.add(col);
        }
        if (isIdProperty && columns.size() == 1 && pef.getPaEClass().getIdClass() == null) {
            columns.get(0).setNullable(false);
            columns.get(0).setUnique(false);
        }
        for (Column column : columns) {
            this.addColumn(propertyElement, pef, column, isNullable, setColumnAttributesInProperty);
        }
        if (hbFeature.getFormula() != null) {
            propertyElement.addElement("formula").addText(hbFeature.getFormula().getValue());
        }
    }

    protected String getColumnName(PAnnotatedEStructuralFeature pef) {
        if (this.getHbmContext().getEmbeddingFeature() != null) {
            PAnnotatedEStructuralFeature embeddingFeature = this.getHbmContext().getEmbeddingFeature();
            return this.getHbmContext().getSqlNameStrategy().getColumnName(pef, embeddingFeature.getModelEStructuralFeature().getName());
        }
        return this.getHbmContext().getSqlNameStrategy().getColumnName(pef, null);
    }

    protected Element addCommentElement(EModelElement eModelElement, Element hbmElement) {
        if (this.hbmContext.getMaximumCommentLength() == 0) {
            return null;
        }
        String commentData = EcoreUtil.getDocumentation((EModelElement)eModelElement);
        if (commentData != null) {
            Element comment = hbmElement.addElement("comment");
            String commentText = commentData.replace('\'', ' ').replace('\"', ' ');
            if (commentText.length() > this.hbmContext.getMaximumCommentLength()) {
                commentText = commentText.substring(0, this.hbmContext.getMaximumCommentLength());
            }
            comment.addText(commentText);
            return comment;
        }
        return null;
    }

    protected List<Column> getAnyTypeColumns(String featureName, boolean isNullable) {
        ArrayList<Column> result = new ArrayList<Column>();
        Column typeColumn = PannotationFactory.eINSTANCE.createColumn();
        typeColumn.setName(this.hbmContext.trunc(String.valueOf(featureName) + "_type"));
        typeColumn.setNullable(isNullable);
        result.add(typeColumn);
        Column idColumn = PannotationFactory.eINSTANCE.createColumn();
        idColumn.setName(this.hbmContext.trunc(String.valueOf(featureName) + "_id"));
        idColumn.setNullable(isNullable);
        result.add(idColumn);
        return result;
    }

    protected List<Column> getColumns(PAnnotatedEStructuralFeature paFeature) {
        Column defaultColumn = paFeature.getColumn();
        Column oc = this.getHbmContext().getAttributeOverride(paFeature);
        if (oc != null) {
            ArrayList<Column> result = new ArrayList<Column>();
            result.add(oc);
            return result;
        }
        HbAnnotatedETypeElement hae = (HbAnnotatedETypeElement)paFeature;
        if (hae.getHbColumns().size() > 0) {
            return hae.getHbColumns();
        }
        ArrayList<Column> result = new ArrayList<Column>();
        if (defaultColumn != null) {
            result.add(defaultColumn);
        }
        return result;
    }

    private void addColumn(Element propertyElement, PAnnotatedEStructuralFeature pef, Column column, boolean isNullable, boolean setColumnAttributesInProperty) {
        if (column != null) {
            if (setColumnAttributesInProperty) {
                if (propertyElement.getName().compareTo("property") == 0 || propertyElement.getName().compareTo("many-to-one") == 0) {
                    propertyElement.addAttribute("insert", column.isInsertable() ? "true" : "false");
                    propertyElement.addAttribute("update", column.isUpdatable() ? "true" : "false");
                }
                if (!propertyElement.getName().equals("any")) {
                    propertyElement.addAttribute("not-null", isNullable || column.isNullable() ? "false" : "true");
                }
                propertyElement.addAttribute("unique", column.isUnique() ? "true" : "false");
            }
            this.addColumnElement(propertyElement, pef, column, isNullable);
        }
    }

    protected void mapFilter(Element parentElement, List<Filter> filters) {
        for (Filter filter : filters) {
            Element filterElement = parentElement.addElement("filter");
            filterElement.addAttribute("name", filter.getName());
            if (filter.getCondition() == null) continue;
            filterElement.addAttribute("condition", filter.getCondition());
        }
    }

    protected void addCascades(Element associationElement, List<HbCascadeType> cascades, boolean addDeleteOrphan) {
        if (!cascades.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (HbCascadeType cascade : cascades) {
                if (cascade == HbCascadeType.ALL) {
                    sb.append("all,");
                    if (!addDeleteOrphan) break;
                    sb.append("delete-orphan,");
                    break;
                }
                if (cascade == HbCascadeType.PERSIST) {
                    sb.append("persist,");
                    continue;
                }
                if (cascade == HbCascadeType.MERGE) {
                    sb.append("merge,");
                    continue;
                }
                if (cascade == HbCascadeType.REFRESH) {
                    sb.append("refresh,");
                    continue;
                }
                if (cascade == HbCascadeType.REMOVE) {
                    sb.append("delete,");
                    continue;
                }
                if (cascade == HbCascadeType.DELETE) {
                    sb.append("delete,");
                    continue;
                }
                if (cascade == HbCascadeType.DELETE_ORPHAN) {
                    sb.append("delete-orphan,");
                    continue;
                }
                if (cascade == HbCascadeType.EVICT) {
                    sb.append("evict,");
                    continue;
                }
                if (cascade == HbCascadeType.LOCK) {
                    sb.append("lock,");
                    continue;
                }
                if (cascade == HbCascadeType.REPLICATE) {
                    sb.append("replicate,");
                    continue;
                }
                if (cascade == HbCascadeType.SAVE_UPDATE) {
                    sb.append("save-update,");
                    continue;
                }
                throw new MappingException("Cascade " + cascade.getName() + " not supported");
            }
            associationElement.addAttribute("cascade", sb.substring(0, sb.length() - 1));
        }
    }

    public Element createAny(String name, PAnnotatedEStructuralFeature paFeature, Any any, AnyMetaDef anyMetaDef, boolean isMany) {
        AnyMetaDef localAnyMetaDef;
        if (anyMetaDef == null) {
            localAnyMetaDef = HbannotationFactory.eINSTANCE.createAnyMetaDef();
            localAnyMetaDef.setIdType("long");
        } else {
            localAnyMetaDef = anyMetaDef;
        }
        Any localAny = any == null ? HbannotationFactory.eINSTANCE.createAny() : any;
        String tagName = isMany ? "many-to-any" : "any";
        Element anyElement = this.getHbmContext().getCurrent().addElement(tagName).addAttribute("id-type", localAnyMetaDef.getIdType()).addAttribute("meta-type", localAnyMetaDef.getMetaType());
        this.getHbmContext().getCurrent().remove(anyElement);
        if (!isMany) {
            anyElement.addAttribute("name", name);
            ArrayList<HbCascadeType> cascades = new ArrayList<HbCascadeType>();
            if (paFeature instanceof HbAnnotatedEReference) {
                if (((HbAnnotatedEReference)paFeature).getHbCascade() == null) {
                    cascades.add(HbCascadeType.ALL);
                } else {
                    cascades.addAll((Collection<HbCascadeType>)((HbAnnotatedEReference)paFeature).getHbCascade().getValue());
                }
            } else {
                cascades.add(HbCascadeType.ALL);
            }
            this.addCascades(anyElement, cascades, isMany);
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        if (localAny.getMetaColumn() != null) {
            columns.add(localAny.getMetaColumn());
        } else {
            Column typeColumn = PannotationFactory.eINSTANCE.createColumn();
            typeColumn.setName(this.hbmContext.trunc(String.valueOf(paFeature.getModelEStructuralFeature().getName()) + "_type"));
            typeColumn.setNullable(localAny.isOptional());
            columns.add(typeColumn);
        }
        if (paFeature.getColumn() != null) {
            columns.add(paFeature.getColumn());
        } else {
            Column idColumn = PannotationFactory.eINSTANCE.createColumn();
            idColumn.setName(this.hbmContext.trunc(String.valueOf(paFeature.getModelEStructuralFeature().getName()) + "_id"));
            idColumn.setNullable(localAny.isOptional());
            columns.add(idColumn);
        }
        this.addColumnsAndFormula(anyElement, paFeature, columns, paFeature.getModelEStructuralFeature().isRequired(), false);
        return anyElement;
    }

    private void addColumnElement(Element propertyElement, PAnnotatedEStructuralFeature pef, Column column, boolean forceNullable) {
        if (column != null) {
            String uc;
            String name;
            Element columnElement = propertyElement.addElement("column").addAttribute("not-null", column.isNullable() || forceNullable ? "false" : "true").addAttribute("unique", column.isUnique() ? "true" : "false");
            if (column.getName() != null) {
                name = column.getName();
            } else if (this.getHbmContext().getEmbeddingFeature() != null) {
                PAnnotatedEStructuralFeature embeddingFeature = this.getHbmContext().getEmbeddingFeature();
                name = this.getHbmContext().getSqlNameStrategy().getColumnName(pef, embeddingFeature.getModelEStructuralFeature().getName());
            } else {
                name = this.getHbmContext().getSqlNameStrategy().getColumnName(pef, null);
            }
            columnElement.addAttribute("name", this.getHbmContext().trunc(name));
            if (column.isSetLength()) {
                columnElement.addAttribute("length", Integer.toString(column.getLength()));
            }
            if (column.isSetPrecision()) {
                columnElement.addAttribute("precision", Integer.toString(column.getPrecision()));
            }
            if (column.isSetScale()) {
                columnElement.addAttribute("scale", Integer.toString(column.getScale()));
            }
            if (column.getColumnDefinition() != null) {
                columnElement.addAttribute("sql-type", column.getColumnDefinition());
            }
            if ((uc = this.getHbmContext().getUniqueConstraintKey(name)) != null) {
                columnElement.addAttribute("unique-key", uc);
            }
            if (pef instanceof HbAnnotatedETypeElement && ((HbAnnotatedETypeElement)pef).getHbIndex() != null) {
                Index index = ((HbAnnotatedETypeElement)pef).getHbIndex();
                columnElement.addAttribute("index", index.getName());
            }
            this.addCommentElement((EModelElement)pef.getModelElement(), columnElement);
        }
    }

    protected void handleOndelete(Element keyElement, OnDelete onDelete) {
    }

    protected boolean isEObject(String typeName) {
        if (typeName == null) {
            return false;
        }
        return typeName.compareTo(EntityNameStrategy.EOBJECT_ECLASS_NAME) == 0;
    }
}

