/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOClassProxy;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageManager;
import org.eclipse.emf.cdo.internal.server.Transaction;
import org.eclipse.emf.cdo.server.IStoreWriter;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStore;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStoreWriter;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateThreadContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.emf.cdo.server.internal.hibernate.bundle.OM;
import org.eclipse.emf.cdo.spi.common.InternalCDOClass;
import org.eclipse.emf.cdo.spi.common.InternalCDOFeature;
import org.eclipse.emf.cdo.spi.common.InternalCDOPackage;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernatePackageHandler
extends Lifecycle {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HibernateStoreWriter.class);
    private Configuration configuration;
    private SessionFactory sessionFactory;
    private int nextPackageID;
    private int nextClassID;
    private int nextFeatureID;
    private Collection<CDOPackageInfo> cdoPackageInfos = null;
    private HibernateStore hibernateStore;

    public HibernatePackageHandler(HibernateStore store) {
        this.hibernateStore = store;
    }

    public List<CDOPackage> getCDOPackages() {
        IStoreWriter.CommitContext cc;
        ArrayList<CDOPackage> cdoPackages = new ArrayList<CDOPackage>();
        if (HibernateThreadContext.isHibernateCommitContextSet() && (cc = HibernateThreadContext.getHibernateCommitContext().getCommitContext()) instanceof Transaction) {
            Transaction tx = (Transaction)cc;
            CDOPackage[] cDOPackageArray = tx.getNewPackages();
            int n = cDOPackageArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOPackage cdoPackage = cDOPackageArray[n2];
                cdoPackages.add(cdoPackage);
                ++n2;
            }
        }
        CDOPackage[] cDOPackageArray = this.hibernateStore.getRepository().getPackageManager().getPackages();
        int n = cDOPackageArray.length;
        int n3 = 0;
        while (n3 < n) {
            CDOPackage cdoPackage = cDOPackageArray[n3];
            cdoPackages.add(cdoPackage);
            ++n3;
        }
        for (CDOPackage cdoPackage : cdoPackages) {
            if (cdoPackage.getClassCount() != 0 || !TRACER.isEnabled()) continue;
            TRACER.trace("Returning " + cdoPackage.getPackageURI());
        }
        return cdoPackages;
    }

    public void writePackages(CDOPackage ... cdoPackages) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Persisting new CDOPackages");
        }
        Session session = this.getSessionFactory().openSession();
        org.hibernate.Transaction tx = session.beginTransaction();
        boolean err = true;
        boolean updated = false;
        try {
            CDOPackage[] cDOPackageArray = cdoPackages;
            int n = cdoPackages.length;
            int n2 = 0;
            while (n2 < n) {
                CDOPackage cdoPackage = cDOPackageArray[n2];
                if (this.cdoPackageExistsAndIsUnchanged(cdoPackage)) {
                    OM.LOG.warn("CDOPackage " + cdoPackage.getPackageURI() + " already exists not persisting it again!");
                } else {
                    if (TRACER.isEnabled()) {
                        TRACER.trace("Persisting CDOPackage " + cdoPackage.getPackageURI());
                    }
                    session.saveOrUpdate((Object)cdoPackage);
                    updated = true;
                }
                ++n2;
            }
            tx.commit();
            err = false;
        }
        finally {
            if (err) {
                tx.rollback();
            }
            session.close();
        }
        if (updated) {
            this.reset();
            this.hibernateStore.reInitialize();
        }
    }

    protected boolean cdoPackageExistsAndIsUnchanged(CDOPackage newCDOPackage) {
        CDOPackage[] cdoPackages;
        CDOPackage[] cDOPackageArray = cdoPackages = this.hibernateStore.getRepository().getPackageManager().getPackages();
        int n = cdoPackages.length;
        int n2 = 0;
        while (n2 < n) {
            CDOPackage cdoPackage = cDOPackageArray[n2];
            if (cdoPackage.getClassCount() > 0 && cdoPackage.getPackageURI().compareTo(newCDOPackage.getPackageURI()) == 0) {
                return cdoPackage.getEcore().compareTo(newCDOPackage.getEcore()) == 0;
            }
            ++n2;
        }
        return false;
    }

    public void writePackage(CDOPackage cdoPackage) {
        if (this.cdoPackageExistsAndIsUnchanged(cdoPackage)) {
            OM.LOG.warn("CDOPackage " + cdoPackage.getPackageURI() + " already exists not persisting it again!");
            return;
        }
        Session session = this.getSessionFactory().openSession();
        org.hibernate.Transaction tx = session.beginTransaction();
        boolean err = true;
        try {
            if (TRACER.isEnabled()) {
                TRACER.trace("Persisting CDOPackage " + cdoPackage.getPackageURI());
            }
            session.saveOrUpdate((Object)cdoPackage);
            tx.commit();
            err = false;
        }
        finally {
            if (err) {
                tx.rollback();
            }
            session.close();
        }
        this.reset();
        this.hibernateStore.reInitialize();
    }

    public Collection<CDOPackageInfo> getCDOPackageInfos() {
        this.readPackageInfos();
        return this.cdoPackageInfos;
    }

    protected void readPackage(CDOPackage cdoPackage) {
        if (cdoPackage.getClassCount() > 0) {
            return;
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("Reading CDOPackage with uri " + cdoPackage.getPackageURI() + " from db");
        }
        Session session = this.getSessionFactory().openSession();
        try {
            Criteria criteria = session.createCriteria(CDOPackage.class);
            criteria.add((Criterion)Expression.eq((String)"packageURI", (Object)cdoPackage.getPackageURI()));
            List list = criteria.list();
            if (list.size() != 1) {
                throw new IllegalArgumentException("CDOPackage with uri " + cdoPackage.getPackageURI() + " not present in the db");
            }
            if (TRACER.isEnabled()) {
                TRACER.trace("Found " + list.size() + " CDOPackages in DB");
            }
            CDOPackage dbPackage = (CDOPackage)list.get(0);
            if (TRACER.isEnabled()) {
                TRACER.trace("Read CDOPackage: " + cdoPackage.getName());
            }
            ((InternalCDOPackage)cdoPackage).setServerInfo(dbPackage.getServerInfo());
            ((InternalCDOPackage)cdoPackage).setName(dbPackage.getName());
            ((InternalCDOPackage)cdoPackage).setEcore(dbPackage.getEcore());
            ((InternalCDOPackage)cdoPackage).setMetaIDRange(cdoPackage.getMetaIDRange());
            ArrayList<CDOClass> cdoClasses = new ArrayList<CDOClass>();
            CDOClass[] cDOClassArray = dbPackage.getClasses();
            int n = cDOClassArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOClass cdoClass = cDOClassArray[n2];
                cdoClasses.add(cdoClass);
                for (CDOClassProxy proxy : ((InternalCDOClass)cdoClass).getSuperTypeProxies()) {
                    proxy.setCDOPackageManager((CDOPackageManager)this.hibernateStore.getRepository().getPackageManager());
                }
                CDOFeature[] cDOFeatureArray = cdoClass.getFeatures();
                int n3 = cDOFeatureArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    CDOFeature cdoFeature = cDOFeatureArray[n4];
                    InternalCDOFeature internalFeature = (InternalCDOFeature)cdoFeature;
                    internalFeature.setContainingClass(cdoClass);
                    if (internalFeature.getReferenceTypeProxy() != null) {
                        internalFeature.getReferenceTypeProxy().setCDOPackageManager((CDOPackageManager)this.hibernateStore.getRepository().getPackageManager());
                    }
                    ++n4;
                }
                ++n2;
            }
            ((InternalCDOPackage)cdoPackage).setClasses(cdoClasses);
        }
        finally {
            session.close();
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("Finished reading CDOPackages");
        }
    }

    protected void readPackageInfos() {
        if (this.cdoPackageInfos == null || this.cdoPackageInfos.size() == 0) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Reading CDOPackages from db");
            }
            ArrayList<CDOPackageInfo> result = new ArrayList<CDOPackageInfo>();
            Session session = this.getSessionFactory().openSession();
            try {
                Criteria criteria = session.createCriteria(CDOPackage.class);
                List list = criteria.list();
                if (TRACER.isEnabled()) {
                    TRACER.trace("Found " + list.size() + " CDOPackages in DB");
                }
                for (Object object : list) {
                    CDOPackage cdoPackage = (CDOPackage)object;
                    if (TRACER.isEnabled()) {
                        TRACER.trace("Read CDOPackage: " + cdoPackage.getName());
                    }
                    result.add(new CDOPackageInfo(cdoPackage.getPackageURI(), cdoPackage.isDynamic(), cdoPackage.getMetaIDRange(), cdoPackage.getParentURI()));
                    ((InternalCDOPackage)cdoPackage).setPackageManager((CDOPackageManager)this.hibernateStore.getRepository().getPackageManager());
                }
                this.cdoPackageInfos = result;
            }
            finally {
                session.close();
            }
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("Finished reading CDOPackages");
        }
    }

    public synchronized SessionFactory getSessionFactory() {
        if (this.sessionFactory == null) {
            this.sessionFactory = this.configuration.buildSessionFactory();
        }
        return this.sessionFactory;
    }

    public synchronized int getNextPackageID() {
        return this.nextPackageID++;
    }

    public synchronized int getNextClassID() {
        return this.nextClassID++;
    }

    public synchronized int getNextFeatureID() {
        return this.nextFeatureID++;
    }

    public void reset() {
        this.cdoPackageInfos = null;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.initConfiguration();
        this.initSchema();
    }

    protected void doDeactivate() throws Exception {
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
        this.cdoPackageInfos = null;
        super.doDeactivate();
    }

    void doDropSchema() {
        SchemaExport se = new SchemaExport(this.configuration);
        se.drop(false, true);
    }

    protected void initConfiguration() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Initializing configuration for CDO metadata");
        }
        InputStream in = null;
        try {
            try {
                in = OM.BUNDLE.getInputStream("mappings/meta.hbm.xml");
                this.configuration = new Configuration();
                this.configuration.addInputStream(in);
                Properties props = new Properties();
                props.putAll((Map<?, ?>)HibernateUtil.getInstance().getPropertiesFromStore(this.hibernateStore));
                if (this.configuration.getProperty("hibernate.hbm2ddl.auto") != null && this.configuration.getProperty("hibernate.hbm2ddl.auto").startsWith("create")) {
                    this.configuration.setProperty("hibernate.hbm2ddl.auto", "update");
                }
                this.configuration.setProperties(props);
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close((Closeable)in);
    }

    protected void initSchema() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Updating db schema for Hibernate PackageHandler");
        }
        new SchemaUpdate(this.configuration).execute(true, true);
    }
}

