/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.model.CDOClassProxy;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.server.IStoreWriter;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.hibernate.IHibernateStoreWriter;
import org.eclipse.emf.cdo.server.hibernate.id.CDOIDHibernate;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStore;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStoreReader;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateThreadContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.emf.cdo.server.internal.hibernate.bundle.OM;
import org.eclipse.emf.cdo.spi.common.InternalCDOClass;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.Session;

public class HibernateStoreWriter
extends HibernateStoreReader
implements IHibernateStoreWriter {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HibernateStoreWriter.class);

    public HibernateStoreWriter(HibernateStore store, IView view) {
        super(store, view);
    }

    public void commit(IStoreWriter.CommitContext context) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Committing transaction");
        }
        HibernateThreadContext.setCommitContext(context);
        this.writePackages(context.getNewPackages());
        boolean err = true;
        try {
            try {
                Session session = this.getHibernateSession();
                session.setFlushMode(FlushMode.MANUAL);
                List<CDORevision> cdoRevisions = Arrays.asList(context.getNewObjects());
                ArrayList<InternalCDORevision> repairContainerIDs = new ArrayList<InternalCDORevision>();
                for (CDORevision cDORevision : cdoRevisions) {
                    CDOID containerID;
                    if (cDORevision instanceof InternalCDORevision && !(containerID = ((InternalCDORevision)cDORevision).getContainerID()).isNull() && containerID instanceof CDOIDTemp) {
                        repairContainerIDs.add((InternalCDORevision)cDORevision);
                    }
                    session.save(HibernateUtil.getInstance().getEntityName(cDORevision), (Object)cDORevision);
                    if (!TRACER.isEnabled()) continue;
                    TRACER.trace("Persisted new Object " + cDORevision.getCDOClass().getName() + " id: " + cDORevision.getID());
                }
                CDORevision[] cDORevisionArray = context.getDirtyObjects();
                int containerID = cDORevisionArray.length;
                int n = 0;
                while (n < containerID) {
                    CDORevision cDORevision = cDORevisionArray[n];
                    if (cDORevision instanceof InternalCDORevision) {
                        ((InternalCDORevision)cDORevision).setVersion(cDORevision.getVersion() - 1);
                    }
                    ++n;
                }
                cDORevisionArray = context.getDirtyObjects();
                containerID = cDORevisionArray.length;
                n = 0;
                while (n < containerID) {
                    CDORevision cDORevision = cDORevisionArray[n];
                    session.update(HibernateUtil.getInstance().getEntityName(cDORevision), (Object)cDORevision);
                    if (TRACER.isEnabled()) {
                        TRACER.trace("Updated Object " + cDORevision.getCDOClass().getName() + " id: " + cDORevision.getID());
                    }
                    ++n;
                }
                session.flush();
                for (InternalCDORevision internalCDORevision : repairContainerIDs) {
                    CDORevision container = HibernateUtil.getInstance().getCDORevision(internalCDORevision.getContainerID());
                    String entityName = HibernateUtil.getInstance().getEntityName((CDORevision)internalCDORevision);
                    CDOIDHibernate id = (CDOIDHibernate)internalCDORevision.getID();
                    CDOIDHibernate containerID2 = (CDOIDHibernate)container.getID();
                    String hqlUpdate = "update " + entityName + " set _contID_Entity = :contEntity, _contID_ID=:contID, _contID_class=:contClass where e_id = :id";
                    Query qry = session.createQuery(hqlUpdate);
                    qry.setParameter("contEntity", (Object)containerID2.getEntityName());
                    qry.setParameter("contID", (Object)containerID2.getId().toString());
                    qry.setParameter("contClass", (Object)containerID2.getId().getClass().getName());
                    qry.setParameter("id", (Object)id.getId());
                    if (qry.executeUpdate() == 1) continue;
                    throw new IllegalStateException("Not able to update container columns of " + entityName + " with id " + id);
                }
                session.flush();
                this.endHibernateSession();
                err = false;
            }
            catch (Exception e) {
                OM.LOG.error((Throwable)e);
                throw WrappedException.wrap((Exception)e);
            }
        }
        finally {
            if (err) {
                this.setErrorOccured(true);
            }
            if (TRACER.isEnabled()) {
                TRACER.trace("Clearing used hibernate session");
            }
            if (TRACER.isEnabled()) {
                TRACER.trace("Applying id mappings");
            }
            context.applyIDMappings();
            HibernateThreadContext.setCommitContext(null);
        }
    }

    public boolean isReader() {
        return false;
    }

    public void rollback(IStoreWriter.CommitContext context) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Rollbacked called");
        }
    }

    protected void writeClass(InternalCDOClass cdoClass) {
        throw new UnsupportedOperationException("Should not be called, should be handled by hibernate cascade");
    }

    protected void writeFeature(CDOFeature feature) {
        throw new UnsupportedOperationException("Should not be called, should be handled by hibernate cascade");
    }

    protected void writePackages(CDOPackage ... cdoPackages) {
        if (cdoPackages != null && cdoPackages.length != 0) {
            this.getStore().getPackageHandler().writePackages(cdoPackages);
        }
        this.resetHibernateSession();
    }

    protected void writePackage(CDOPackage cdoPackage) {
        throw new UnsupportedOperationException("Should not be called");
    }

    protected void writeRevision(CDORevision revision) {
    }

    protected void writeRevisionDelta(CDORevisionDelta revisionDelta) {
    }

    protected void writeRevisionDeltas(CDORevisionDelta[] revisionDeltas) {
    }

    protected void writeRevisions(CDORevision[] revisions) {
    }

    protected void writeSuperType(InternalCDOClass type, CDOClassProxy superType) {
        throw new UnsupportedOperationException("Should not be called, should be handled by hibernate cascade");
    }
}

