/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import org.eclipse.emf.cdo.CDOTransaction;
import org.eclipse.emf.cdo.CDOView;
import org.eclipse.emf.cdo.internal.ui.actions.ViewAction;
import org.eclipse.emf.cdo.internal.ui.dialogs.RollbackTransactionDialog;
import org.eclipse.ui.IWorkbenchPage;

public final class RollbackTransactionAction
extends ViewAction {
    private static final String TITLE = "Rollback";
    private static final String TOOL_TIP = "Rollback this transaction";
    private boolean remote;

    public RollbackTransactionAction(IWorkbenchPage page, CDOView view) {
        super(page, "Rollback...", TOOL_TIP, null, view);
        this.setEnabled(this.getTransaction().isDirty());
    }

    protected void preRun() throws Exception {
        CDOTransaction transaction = (CDOTransaction)this.getView();
        RollbackTransactionDialog dialog = new RollbackTransactionDialog(this.getPage(), TITLE, "Choose how to rollback this transaction.", transaction);
        switch (dialog.open()) {
            case 2: {
                this.remote = true;
                break;
            }
            case 3: {
                this.remote = false;
                break;
            }
            default: {
                this.cancel();
            }
        }
    }

    protected void doRun() throws Exception {
        this.getTransaction().rollback(this.remote);
    }
}

