/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.util;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOSession;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.CDOView;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.util.LegacySystemNotAvailableException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.internal.cdo.CDOAdapterImpl;
import org.eclipse.emf.internal.cdo.CDOLegacyImpl;
import org.eclipse.emf.internal.cdo.CDOMetaImpl;
import org.eclipse.emf.internal.cdo.CDOViewImpl;
import org.eclipse.emf.internal.cdo.InternalCDOObject;
import org.eclipse.emf.internal.cdo.bundle.OM;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FSMUtil {
    private static Method adaptLegacyMethod = FSMUtil.initAdaptLegacyMethod();

    private FSMUtil() {
    }

    private static Method initAdaptLegacyMethod() {
        try {
            Class[] params;
            Method method;
            Class<?> c = Class.forName("org.eclipse.emf.internal.cdo.CDOCallbackImpl");
            if (c != null && (method = c.getDeclaredMethod("adapt", params = new Class[]{Object.class, CDOView.class})) != null) {
                return method;
            }
        }
        catch (Throwable throwable) {}
        OM.LOG.info("Legacy system not available");
        return null;
    }

    public static boolean isLegacySystemAvailable() {
        return adaptLegacyMethod != null;
    }

    public static void checkLegacySystemAvailability(CDOSession session, CDOObject object) throws LegacySystemNotAvailableException {
        if (!session.isLegacySupportEnabled() && object instanceof CDOLegacyImpl) {
            throw new LegacySystemNotAvailableException();
        }
    }

    public static boolean isTransient(CDOObject object) {
        CDOState state = object.cdoState();
        return state == CDOState.TRANSIENT || state == CDOState.PREPARED;
    }

    public static InternalCDOObject adapt(Object object, CDOView view) {
        if (object == null) {
            throw new IllegalArgumentException("object == null");
        }
        if (object instanceof InternalCDOObject) {
            return (InternalCDOObject)object;
        }
        if (object instanceof EModelElement || object instanceof EGenericType || object instanceof EStringToStringMapEntryImpl) {
            CDOID id;
            InternalEObject eObject = (InternalEObject)object;
            if (view == null) {
                throw new IllegalArgumentException("view == null");
            }
            if (eObject.eIsProxy()) {
                eObject = (InternalEObject)EcoreUtil.resolve((EObject)eObject, (ResourceSet)view.getResourceSet());
            }
            if ((id = ((CDOViewImpl)view).getSession().lookupMetaInstanceID(eObject)) != null) {
                return new CDOMetaImpl((CDOViewImpl)view, eObject, id);
            }
        }
        if (FSMUtil.isLegacySystemAvailable()) {
            try {
                return (InternalCDOObject)adaptLegacyMethod.invoke(null, object, view);
            }
            catch (Throwable t) {
                OM.LOG.info(t);
            }
        }
        if (object instanceof InternalEObject) {
            EList adapters = ((InternalEObject)object).eAdapters();
            CDOAdapterImpl adapter = (CDOAdapterImpl)EcoreUtil.getAdapter((List)adapters, CDOAdapterImpl.class);
            if (adapter == null) {
                adapter = new CDOAdapterImpl();
                adapters.add((Object)adapter);
            }
            return adapter;
        }
        return null;
    }

    public static Iterator<InternalCDOObject> iterator(Collection<?> instances, final CDOViewImpl view) {
        final Iterator<?> delegate = instances.iterator();
        return new Iterator<InternalCDOObject>(){
            private Object next;

            @Override
            public boolean hasNext() {
                while (delegate.hasNext()) {
                    this.next = FSMUtil.adapt(delegate.next(), view);
                    if (!(this.next instanceof InternalCDOObject)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public InternalCDOObject next() {
                return (InternalCDOObject)this.next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

