/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.examples.general.actions;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.examples.extlibrary.presentation.EXTLibraryEditor;
import org.eclipse.emf.validation.examples.general.ValidationPlugin;
import org.eclipse.emf.validation.examples.general.constraints.ValidationDelegateClientSelector;
import org.eclipse.emf.validation.examples.general.internal.l10n.ValidationMessages;
import org.eclipse.emf.validation.marker.MarkerUtil;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ListDialog;

public class BatchValidationDelegate
implements IEditorActionDelegate,
IActionDelegate2 {
    protected static final String MESSAGE_EXCEPTION = ValidationMessages.message_exception;
    protected Shell shell = null;
    protected EXTLibraryEditor editor = null;
    protected Collection<EObject> selectedEObjects = null;
    private final String title = ValidationMessages.BatchValidationDelegate_title;

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedEObjects = null;
        try {
            try {
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    List selectedHunh = structuredSelection.toList();
                    for (Object next : selectedHunh) {
                        if (next instanceof EObject) continue;
                        action.setEnabled(false);
                    }
                    this.selectedEObjects = action.isEnabled() ? selectedHunh : null;
                }
            }
            catch (Exception e) {
                MessageDialog.openInformation((Shell)this.shell, (String)this.title, (String)MESSAGE_EXCEPTION);
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            action.setEnabled(this.selectedEObjects != null);
            throw throwable;
        }
        action.setEnabled(this.selectedEObjects != null);
    }

    public void dispose() {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = (EXTLibraryEditor)targetEditor;
        if (targetEditor != null) {
            this.shell = targetEditor.getSite().getShell();
        }
    }

    public void init(IAction action) {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(IAction action) {
        ValidationDelegateClientSelector.running = true;
        IBatchValidator validator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        validator.setIncludeLiveConstraints(true);
        final IStatus status = validator.validate(this.selectedEObjects);
        if (status.isOK()) {
            MessageDialog.openInformation((Shell)this.shell, (String)this.title, (String)ValidationMessages.BatchValidationDelegate_successMessage);
            return;
        }
        ListDialog dialog = new ListDialog(this.shell);
        dialog.setInput((Object)status);
        dialog.setTitle(this.title);
        dialog.setContentProvider(new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (status != null && status.isMultiStatus() && status == inputElement) {
                    return status.getChildren();
                }
                if (status != null && status == inputElement) {
                    return new Object[]{status};
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IStatus) {
                    return ((IStatus)element).getMessage();
                }
                return null;
            }
        });
        dialog.setBlockOnOpen(true);
        dialog.setMessage(ValidationMessages.BatchValidationDelegate_errorMessage);
        if (dialog.open() == 0) {
            HashSet<EObject> errorSelections = new HashSet<EObject>();
            if (!status.isMultiStatus()) {
                IConstraintStatus cstatus = (IConstraintStatus)status;
                errorSelections.add(cstatus.getTarget());
            } else {
                IStatus[] children;
                IStatus[] iStatusArray = children = status.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus element = iStatusArray[n2];
                    IConstraintStatus cstatus = (IConstraintStatus)element;
                    errorSelections.add(cstatus.getTarget());
                    ++n2;
                }
            }
            this.editor.setSelectionToViewer(errorSelections);
        }
        ValidationDelegateClientSelector.running = false;
        try {
            MarkerUtil.createMarkers((IStatus)status);
        }
        catch (CoreException e) {
            ValidationPlugin.getDefault().getLog().log(e.getStatus());
        }
    }
}

