/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.buddies.protocol;

import java.io.IOException;
import java.util.Set;
import org.eclipse.net4j.buddies.IBuddySession;
import org.eclipse.net4j.buddies.common.IAccount;
import org.eclipse.net4j.buddies.internal.common.protocol.ProtocolUtil;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.internal.buddies.ClientSession;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSessionRequest
extends RequestWithConfirmation<IBuddySession> {
    private String userID;
    private String password;
    private Set<String> facilityTypes;

    public OpenSessionRequest(IChannel channel, String userID, String password, Set<String> facilityTypes) {
        super(channel);
        this.userID = userID;
        this.password = password;
        this.facilityTypes = facilityTypes;
    }

    protected short getSignalID() {
        return 1;
    }

    protected void requesting(ExtendedDataOutputStream out) throws IOException {
        out.writeString(this.userID);
        out.writeString(this.password);
        out.writeInt(this.facilityTypes.size());
        for (String facilityType : this.facilityTypes) {
            out.writeString(facilityType);
        }
    }

    protected IBuddySession confirming(ExtendedDataInputStream in) throws IOException {
        IAccount account = ProtocolUtil.readAccount((ExtendedDataInputStream)in);
        if (account == null) {
            return null;
        }
        ClientSession session = new ClientSession(this.getProtocol().getChannel());
        this.getProtocol().setInfraStructure((Object)session);
        session.setSelf(account, this.facilityTypes);
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            session.buddyAdded(in.readString());
            ++i;
        }
        session.activate();
        return session;
    }
}

