/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.net4j.acceptor;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.IElementProcessor;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.IFactoryKey;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.registry.IRegistry;
import org.eclipse.net4j.util.security.INegotiator;
import org.eclipse.spi.net4j.InternalAcceptor;
import org.eclipse.spi.net4j.InternalConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Acceptor
extends Container<IConnector>
implements InternalAcceptor {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_ACCEPTOR, Acceptor.class);
    private INegotiator negotiator;
    private IBufferProvider bufferProvider;
    private IRegistry<IFactoryKey, IFactory> protocolFactoryRegistry;
    private List<IElementProcessor> protocolPostProcessors;
    private ExecutorService receiveExecutor;
    private transient IListener connectorListener = new LifecycleEventAdapter(){

        protected void onDeactivated(ILifecycle lifecycle) {
            Acceptor.this.removeConnector((IConnector)lifecycle);
        }
    };
    private Set<IConnector> acceptedConnectors = new HashSet<IConnector>(0);

    @Override
    public INegotiator getNegotiator() {
        return this.negotiator;
    }

    @Override
    public void setNegotiator(INegotiator negotiator) {
        this.negotiator = negotiator;
    }

    @Override
    public IBufferProvider getBufferProvider() {
        return this.bufferProvider;
    }

    @Override
    public void setBufferProvider(IBufferProvider bufferProvider) {
        this.bufferProvider = bufferProvider;
    }

    @Override
    public ExecutorService getReceiveExecutor() {
        return this.receiveExecutor;
    }

    @Override
    public void setReceiveExecutor(ExecutorService receiveExecutor) {
        this.receiveExecutor = receiveExecutor;
    }

    @Override
    public IRegistry<IFactoryKey, IFactory> getProtocolFactoryRegistry() {
        return this.protocolFactoryRegistry;
    }

    @Override
    public void setProtocolFactoryRegistry(IRegistry<IFactoryKey, IFactory> protocolFactoryRegistry) {
        this.protocolFactoryRegistry = protocolFactoryRegistry;
    }

    @Override
    public List<IElementProcessor> getProtocolPostProcessors() {
        return this.protocolPostProcessors;
    }

    @Override
    public void setProtocolPostProcessors(List<IElementProcessor> protocolPostProcessors) {
        this.protocolPostProcessors = protocolPostProcessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IConnector[] getAcceptedConnectors() {
        Set<IConnector> set = this.acceptedConnectors;
        synchronized (set) {
            return this.acceptedConnectors.toArray(new IConnector[this.acceptedConnectors.size()]);
        }
    }

    public boolean isEmpty() {
        return this.acceptedConnectors.isEmpty();
    }

    public IConnector[] getElements() {
        return this.getAcceptedConnectors();
    }

    public void prepareConnector(InternalConnector connector) {
        connector.setNegotiator(this.negotiator);
        connector.setBufferProvider(this.bufferProvider);
        connector.setReceiveExecutor(this.receiveExecutor);
        connector.setProtocolFactoryRegistry(this.protocolFactoryRegistry);
        connector.setProtocolPostProcessors(this.protocolPostProcessors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnector(InternalConnector connector) {
        Set<IConnector> set = this.acceptedConnectors;
        synchronized (set) {
            this.acceptedConnectors.add(connector);
        }
        connector.addListener(this.connectorListener);
        if (TRACER.isEnabled()) {
            TRACER.trace("Added connector " + connector);
        }
        this.fireElementAddedEvent(connector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnector(IConnector connector) {
        connector.removeListener(this.connectorListener);
        Set<IConnector> set = this.acceptedConnectors;
        synchronized (set) {
            this.acceptedConnectors.remove(connector);
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("Removed connector " + connector);
        }
        this.fireElementRemovedEvent(connector);
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (this.bufferProvider == null) {
            throw new IllegalStateException("bufferProvider == null");
        }
        if (this.protocolFactoryRegistry == null && TRACER.isEnabled()) {
            TRACER.trace("factoryRegistry == null");
        }
        if (this.protocolPostProcessors == null && TRACER.isEnabled()) {
            TRACER.trace("protocolPostProcessors == null");
        }
        if (this.receiveExecutor == null && TRACER.isEnabled()) {
            TRACER.trace("receiveExecutor == null");
        }
    }

    protected void doDeactivate() throws Exception {
        IConnector[] iConnectorArray = this.getAcceptedConnectors();
        int n = iConnectorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConnector connector = iConnectorArray[n2];
            LifecycleUtil.deactivate((Object)connector);
            ++n2;
        }
        super.doDeactivate();
    }
}

