/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDSchemaDirectiveImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDImportImpl
extends XSDSchemaDirectiveImpl
implements XSDImport {
    protected static final String NAMESPACE_EDEFAULT = null;
    protected String namespace = NAMESPACE_EDEFAULT;
    protected XSDAnnotation annotation;

    public static XSDImport createImport(Node node) {
        if (XSDConstants.nodeType(node) == 17) {
            XSDImport xsdImport = XSDFactory.eINSTANCE.createXSDImport();
            xsdImport.setElement((Element)node);
            return xsdImport;
        }
        return null;
    }

    public Element createElement() {
        Element newElement = this.createElement(17);
        this.setElement(newElement);
        return newElement;
    }

    protected XSDImportImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_IMPORT;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String newNamespace) {
        String oldNamespace = this.namespace;
        this.namespace = newNamespace;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldNamespace, (Object)this.namespace));
        }
    }

    public XSDAnnotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(XSDAnnotation newAnnotation) {
        if (newAnnotation != this.annotation) {
            NotificationChain msgs = null;
            if (this.annotation != null) {
                msgs = ((InternalEObject)this.annotation).eInverseRemove((InternalEObject)this, -9, null, msgs);
            }
            if (newAnnotation != null) {
                msgs = ((InternalEObject)newAnnotation).eInverseAdd((InternalEObject)this, -9, null, msgs);
            }
            if ((msgs = this.basicSetAnnotation(newAnnotation, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)newAnnotation, (Object)newAnnotation));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return this.basicSetAnnotation(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain basicSetAnnotation(XSDAnnotation newAnnotation, NotificationChain msgs) {
        XSDAnnotation oldAnnotation = this.annotation;
        this.annotation = newAnnotation;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldAnnotation, (Object)newAnnotation);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 7: {
                return this.getNamespace();
            }
            case 8: {
                return this.getAnnotation();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 7: {
                this.setNamespace((String)newValue);
                return;
            }
            case 8: {
                this.setAnnotation((XSDAnnotation)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 7: {
                this.setNamespace(NAMESPACE_EDEFAULT);
                return;
            }
            case 8: {
                this.setAnnotation(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 7: {
                return NAMESPACE_EDEFAULT == null ? this.namespace != null : !NAMESPACE_EDEFAULT.equals(this.namespace);
            }
            case 8: {
                return this.annotation != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (namespace: ");
        result.append(this.namespace);
        result.append(')');
        return result.toString();
    }

    public void validate() {
        XSDSchema theResolvedSchema;
        super.validate();
        Element theElement = this.getElement();
        if (theElement != null) {
            this.checkAttributes("http://www.w3.org/TR/xmlschema-1/", "element-import", theElement, new String[]{"id", "namespace", "schemaLocation"});
            XSDComplexTypeDefinition xsdComplexTypeDefinition = (XSDComplexTypeDefinition)this.getSchema().getSchemaForSchema().resolveElementDeclaration("import").getTypeDefinition();
            this.checkComplexContent(xsdComplexTypeDefinition, "http://www.w3.org/TR/xmlschema-1/", "element-import", theElement);
            this.checkBuiltInTypeConstraint("ID", null, "http://www.w3.org/TR/xmlschema-1/", "element-import", theElement, "id", false);
        }
        this.checkBuiltInTypeConstraint("anyURI", this.getNamespace(), "http://www.w3.org/TR/xmlschema-1/", "element-import", theElement, "namespace", false);
        this.checkBuiltInTypeConstraint("anyURI", this.getSchemaLocation(), "http://www.w3.org/TR/xmlschema-1/", "element-import", theElement, "schemaLocation", false);
        XSDSchema xsdSchema = this.getSchema();
        if (this.getNamespace() == null ? xsdSchema.getTargetNamespace() == null : this.getNamespace().equals(xsdSchema.getTargetNamespace())) {
            this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-import.1", this.getNamespace() == null ? "" : this.getNamespace());
        }
        if ((theResolvedSchema = this.getResolvedSchema()) == null) {
            this.createDiagnostic(XSDDiagnosticSeverity.WARNING_LITERAL, "src-import.0", this.getSchemaLocation() == null ? "" : this.getSchemaLocation());
        } else if (theResolvedSchema.eResource() == null || theResolvedSchema.getElement() == null || XSDConstants.nodeType(theResolvedSchema.getElement()) != 33) {
            this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-import.2", this.getSchemaLocation() == null ? "" : this.getSchemaLocation());
        } else if (this.getNamespace() == null ? theResolvedSchema.getTargetNamespace() != null : !this.getNamespace().equals(theResolvedSchema.getTargetNamespace())) {
            this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-import.3", theResolvedSchema.getTargetNamespace() == null ? "" : theResolvedSchema.getTargetNamespace(), this.getNamespace() == null ? "" : this.getNamespace());
        }
        if (this.getNamespace() != null && !this.getSchema().getQNamePrefixToNamespaceMap().containsValue(this.getNamespace()) && !XSDConstants.isXMLNamespace(this.getNamespace())) {
            this.createDiagnostic(XSDDiagnosticSeverity.WARNING_LITERAL, "src-import.0.1", this.getNamespace() == null ? "" : this.getNamespace());
        }
    }

    public XSDSchema importSchema() {
        this.resolve(this.getNamespace(), this.getSchemaLocation());
        return this.getResolvedSchema();
    }

    protected void handleResolvedSchema(XSDSchema xsdSchema) {
        if (xsdSchema == null) {
            this.setResolvedSchema(null);
        } else {
            ((XSDSchemaImpl)xsdSchema).imported(this);
        }
    }

    protected void reconcileAttributes(Element changedElement) {
        super.reconcileAttributes(changedElement);
        String newNamespace = null;
        if (changedElement.hasAttributeNS(null, "namespace")) {
            newNamespace = changedElement.getAttributeNS(null, "namespace");
        }
        if (newNamespace == null ? this.getNamespace() != null : !newNamespace.equals(this.getNamespace())) {
            this.setNamespace(newNamespace);
        }
    }

    protected void changeAttribute(EAttribute eAttribute) {
        if (this.isReconciling) {
            return;
        }
        super.changeAttribute(eAttribute);
        if (eAttribute == null || eAttribute == XSDPackage.Literals.XSD_IMPORT__NAMESPACE) {
            Element theElement = this.getElement();
            if (theElement != null) {
                this.niceSetAttribute(theElement, "namespace", this.getNamespace());
            }
            if (eAttribute != null && this.getResolvedSchema() != null && this.getSchema().isIncrementalUpdate()) {
                this.getSchema().reset();
            }
        }
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDImportImpl clonedImport = (XSDImportImpl)this.getXSDFactory().createXSDImport();
        clonedImport.isReconciling = true;
        clonedImport.setNamespace(this.getNamespace());
        clonedImport.setSchemaLocation(this.getSchemaLocation());
        if (deep && this.getAnnotation() != null) {
            clonedImport.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(deep, shareDOM));
        }
        if (shareDOM && this.getElement() != null) {
            clonedImport.setElement(this.getElement());
        }
        clonedImport.isReconciling = shareDOM;
        return clonedImport;
    }
}

