/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOClassProxy;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.model.CDOPackageManager;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaImpl;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOContainerFeatureDeltaImpl
extends CDOFeatureDeltaImpl
implements CDOContainerFeatureDelta {
    private static CDOFeature CONTAINER_FEATURE = new ContainerFeature();
    private CDOID newContainerID;
    private int newContainerFeatureID;

    public CDOContainerFeatureDeltaImpl(CDOID newContainerID, int newContainerFeatureID) {
        super(CONTAINER_FEATURE);
        this.newContainerID = newContainerID;
        this.newContainerFeatureID = newContainerFeatureID;
    }

    public CDOContainerFeatureDeltaImpl(ExtendedDataInput in, CDOClass cdoClass) throws IOException {
        super(CONTAINER_FEATURE);
        this.newContainerFeatureID = in.readInt();
        this.newContainerID = CDOIDUtil.read(in, cdoClass.getPackageManager().getCDOIDObjectFactory());
    }

    @Override
    public int getContainerFeatureID() {
        return this.newContainerFeatureID;
    }

    @Override
    public CDOID getContainerID() {
        return this.newContainerID;
    }

    @Override
    public CDOFeatureDelta.Type getType() {
        return CDOFeatureDelta.Type.CONTAINER;
    }

    @Override
    public void apply(CDORevision revision) {
        ((InternalCDORevision)revision).setContainerID(this.newContainerID);
        ((InternalCDORevision)revision).setContainingFeatureID(this.newContainerFeatureID);
    }

    @Override
    public void adjustReferences(Map<CDOIDTemp, CDOID> idMappings) {
        this.newContainerID = (CDOID)CDORevisionUtil.remapID(this.newContainerID, idMappings);
    }

    @Override
    public void write(ExtendedDataOutput out, CDOClass cdoClass, CDOIDProvider idProvider) throws IOException {
        out.writeInt(this.getType().ordinal());
        out.writeInt(this.newContainerFeatureID);
        CDOIDUtil.write(out, this.newContainerID);
    }

    @Override
    public void accept(CDOFeatureDeltaVisitor visitor) {
        visitor.visit(this);
    }

    private static final class ContainerFeature
    implements CDOFeature {
        private ContainerFeature() {
        }

        public CDOClass getContainingClass() {
            return null;
        }

        public void setContainingClass(CDOClass cdoClass) {
        }

        public CDOPackage getContainingPackage() {
            return null;
        }

        public int getFeatureID() {
            return 0;
        }

        public int getFeatureIndex() {
            return 0;
        }

        public CDOClass getReferenceType() {
            return null;
        }

        public CDOClassProxy getReferenceTypeProxy() {
            return null;
        }

        public CDOType getType() {
            return null;
        }

        public boolean isContainment() {
            return false;
        }

        public boolean isMany() {
            return false;
        }

        public boolean isReference() {
            return false;
        }

        public Object getClientInfo() {
            return null;
        }

        public String getName() {
            return null;
        }

        public CDOPackageManager getPackageManager() {
            return null;
        }

        public Object getServerInfo() {
            return null;
        }

        public void setClientInfo(Object clientInfo) {
        }

        public void setServerInfo(Object serverInfo) {
        }

        public String toString() {
            return "CONTAINER_FEATURE";
        }
    }
}

