/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.cache.lru;

import java.text.MessageFormat;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.internal.common.revision.cache.lru.DLRevisionHolder;
import org.eclipse.emf.cdo.internal.common.revision.cache.lru.DLRevisionList;
import org.eclipse.emf.cdo.internal.common.revision.cache.lru.LRURevisionList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;

public class LRURevisionHolder
extends DLRevisionHolder {
    private long usedStamp = System.currentTimeMillis();

    public LRURevisionHolder(InternalCDORevision revision) {
        super(null, revision);
    }

    public LRURevisionList getDLList() {
        return (LRURevisionList)super.getDLList();
    }

    protected void setDLList(DLRevisionList list) {
        if (list != null && !(list instanceof LRURevisionList)) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("LRURevisionHolder.0"), LRURevisionList.class.getName(), list));
        }
        super.setDLList(list);
    }

    public long getUsedStamp() {
        return this.usedStamp;
    }

    public InternalCDORevision getRevision() {
        this.stamp();
        return super.getRevision();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stamp() {
        this.usedStamp = System.currentTimeMillis();
        LRURevisionList list = this.getDLList();
        if (list != null) {
            LRURevisionList lRURevisionList = list;
            synchronized (lRURevisionList) {
                list.remove(this);
                list.addHead(this);
            }
        }
    }
}

