/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IClassMappingAuditSupport;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalClassMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalMappingStrategy;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class HorizontalAuditClassMapping
extends AbstractHorizontalClassMapping
implements IClassMapping,
IClassMappingAuditSupport {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HorizontalAuditClassMapping.class);
    private String sqlInsertAttributes;
    private String sqlSelectCurrentAttributes;
    private String sqlSelectAllObjectIds;
    private String sqlSelectAttributesByTime;
    private String sqlSelectAttributesByVersion;
    private String sqlReviseAttributes;

    public HorizontalAuditClassMapping(AbstractHorizontalMappingStrategy mappingStrategy, EClass eClass) {
        super(mappingStrategy, eClass);
        this.initSqlStrings();
    }

    private void initSqlStrings() {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append("cdo_version");
        builder.append(", ");
        builder.append("cdo_created");
        builder.append(", ");
        builder.append("cdo_revised");
        builder.append(", ");
        builder.append("cdo_resource");
        builder.append(", ");
        builder.append("cdo_container");
        builder.append(", ");
        builder.append("cdo_feature");
        for (ITypeMapping singleMapping : this.getValueMappings()) {
            builder.append(", ");
            builder.append(singleMapping.getField().getName());
        }
        builder.append(" FROM ");
        builder.append(this.getTable().getName());
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("= ? AND (");
        String sqlSelectAttributesPrefix = builder.toString();
        builder.append("cdo_revised");
        builder.append(" = 0 )");
        this.sqlSelectCurrentAttributes = builder.toString();
        builder = new StringBuilder(sqlSelectAttributesPrefix);
        builder.append("cdo_created");
        builder.append(" <= ? AND ( ");
        builder.append("cdo_revised");
        builder.append(" = 0 OR ");
        builder.append("cdo_revised");
        builder.append(" >= ?))");
        this.sqlSelectAttributesByTime = builder.toString();
        builder = new StringBuilder(sqlSelectAttributesPrefix);
        builder.append("cdo_version");
        builder.append(" = ?)");
        this.sqlSelectAttributesByVersion = builder.toString();
        builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.getTable().getName());
        builder.append(" VALUES (?, ?, ");
        builder.append("?, ?, ?, ?, ?, ?");
        int i = 0;
        while (i < this.getValueMappings().size()) {
            builder.append(", ?");
            ++i;
        }
        builder.append(")");
        this.sqlInsertAttributes = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(this.getTable().getName());
        builder.append(" SET ");
        builder.append("cdo_revised");
        builder.append(" = ? WHERE ");
        builder.append("cdo_id");
        builder.append(" = ? AND ");
        builder.append("cdo_revised");
        builder.append(" = 0");
        this.sqlReviseAttributes = builder.toString();
        builder = new StringBuilder("SELECT ");
        builder.append("cdo_id");
        builder.append(" FROM ");
        builder.append(this.getTable().getName());
        builder.append(" WHERE ");
        builder.append("cdo_revised");
        builder.append(" = 0");
        this.sqlSelectAllObjectIds = builder.toString();
    }

    public boolean readRevisionByTime(IDBStoreAccessor accessor, InternalCDORevision revision, long timeStamp, int listChunk) {
        PreparedStatement pstmt = null;
        try {
            pstmt = accessor.getStatementCache().getPreparedStatement(this.sqlSelectAttributesByTime, IPreparedStatementCache.ReuseProbability.MEDIUM);
            pstmt.setLong(1, CDOIDUtil.getLong((CDOID)revision.getID()));
            pstmt.setLong(2, timeStamp);
            pstmt.setLong(3, timeStamp);
            boolean success = this.readValuesFromStatement(pstmt, revision);
            if (success) {
                this.readLists(accessor, revision, listChunk);
            }
            boolean bl = success;
            accessor.getStatementCache().releasePreparedStatement(pstmt);
            return bl;
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                accessor.getStatementCache().releasePreparedStatement(pstmt);
                throw throwable;
            }
        }
    }

    public boolean readRevisionByVersion(IDBStoreAccessor accessor, InternalCDORevision revision, int version, int listChunk) {
        PreparedStatement pstmt = null;
        try {
            pstmt = accessor.getStatementCache().getPreparedStatement(this.sqlSelectAttributesByVersion, IPreparedStatementCache.ReuseProbability.HIGH);
            pstmt.setLong(1, CDOIDUtil.getLong((CDOID)revision.getID()));
            pstmt.setInt(2, version);
            boolean success = this.readValuesFromStatement(pstmt, revision);
            if (success) {
                this.readLists(accessor, revision, listChunk);
            }
            boolean bl = success;
            accessor.getStatementCache().releasePreparedStatement(pstmt);
            return bl;
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                accessor.getStatementCache().releasePreparedStatement(pstmt);
                throw throwable;
            }
        }
    }

    public PreparedStatement createResourceQueryStatement(IDBStoreAccessor accessor, CDOID folderId, String name, boolean exactMatch, long timeStamp) {
        EAttribute nameFeature = EresourcePackage.eINSTANCE.getCDOResourceNode_Name();
        ITypeMapping nameValueMapping = this.getValueMapping((EStructuralFeature)nameFeature);
        if (nameValueMapping == null) {
            throw new ImplementationError(nameFeature + " not found in ClassMapping " + this);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append("cdo_id");
        builder.append(" FROM ");
        builder.append(this.getTable().getName());
        builder.append(" WHERE ");
        builder.append("cdo_container");
        builder.append("= ? AND ");
        builder.append(nameValueMapping.getField().getName());
        if (name == null) {
            builder.append(" IS NULL");
        } else {
            builder.append(exactMatch ? " = ? " : " LIKE ? ");
        }
        builder.append(" AND ( ");
        if (timeStamp == 0L) {
            builder.append("cdo_revised");
            builder.append(" = 0 )");
        } else {
            builder.append("cdo_created");
            builder.append(" <= ? AND ( ");
            builder.append("cdo_revised");
            builder.append(" = 0 OR ");
            builder.append("cdo_revised");
            builder.append(" >= ?))");
        }
        PreparedStatement pstmt = null;
        try {
            int idx = 1;
            pstmt = accessor.getStatementCache().getPreparedStatement(builder.toString(), IPreparedStatementCache.ReuseProbability.MEDIUM);
            pstmt.setLong(idx++, CDOIDUtil.getLong((CDOID)folderId));
            if (name != null) {
                String queryName = exactMatch ? name : String.valueOf(name) + "%";
                nameValueMapping.setValue(pstmt, idx++, queryName);
            }
            if (timeStamp != 0L) {
                pstmt.setLong(idx++, timeStamp);
                pstmt.setLong(idx++, timeStamp);
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Created Resource Query: {0}", new Object[]{pstmt.toString()});
            }
            return pstmt;
        }
        catch (SQLException ex) {
            accessor.getStatementCache().releasePreparedStatement(pstmt);
            throw new DBException((Throwable)ex);
        }
    }

    public PreparedStatement createObjectIdStatement(IDBStoreAccessor accessor) {
        if (TRACER.isEnabled()) {
            TRACER.format("Created ObjectID Statement : {0}", new Object[]{this.sqlSelectAllObjectIds});
        }
        return accessor.getStatementCache().getPreparedStatement(this.sqlSelectAllObjectIds, IPreparedStatementCache.ReuseProbability.HIGH);
    }

    public boolean readRevision(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        PreparedStatement pstmt = null;
        try {
            pstmt = accessor.getStatementCache().getPreparedStatement(this.sqlSelectCurrentAttributes, IPreparedStatementCache.ReuseProbability.HIGH);
            pstmt.setLong(1, CDOIDUtil.getLong((CDOID)revision.getID()));
            boolean success = this.readValuesFromStatement(pstmt, revision);
            if (success) {
                this.readLists(accessor, revision, listChunk);
            }
            boolean bl = success;
            accessor.getStatementCache().releasePreparedStatement(pstmt);
            return bl;
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                accessor.getStatementCache().releasePreparedStatement(pstmt);
                throw throwable;
            }
        }
    }

    protected final void writeValues(IDBStoreAccessor accessor, InternalCDORevision revision) {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = accessor.getStatementCache().getPreparedStatement(this.sqlInsertAttributes, IPreparedStatementCache.ReuseProbability.HIGH);
                int col = 1;
                stmt.setLong(col++, CDOIDUtil.getLong((CDOID)revision.getID()));
                stmt.setInt(col++, revision.getVersion());
                stmt.setLong(col++, accessor.getStore().getMetaDataManager().getMetaID((EModelElement)revision.getEClass()));
                stmt.setLong(col++, revision.getCreated());
                stmt.setLong(col++, revision.getRevised());
                stmt.setLong(col++, CDOIDUtil.getLong((CDOID)revision.getResourceID()));
                stmt.setLong(col++, CDODBUtil.getLong((CDOID)revision.getContainerID()));
                stmt.setInt(col++, revision.getContainingFeatureID());
                for (ITypeMapping mapping : this.getValueMappings()) {
                    mapping.setValueFromRevision(stmt, col++, revision);
                }
                CDODBUtil.sqlUpdate(stmt, true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            accessor.getStatementCache().releasePreparedStatement(stmt);
            throw throwable;
        }
        accessor.getStatementCache().releasePreparedStatement(stmt);
    }

    protected void reviseObject(IDBStoreAccessor accessor, CDOID id, long revised) {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = accessor.getStatementCache().getPreparedStatement(this.sqlReviseAttributes, IPreparedStatementCache.ReuseProbability.HIGH);
                stmt.setLong(1, revised);
                stmt.setLong(2, CDOIDUtil.getLong((CDOID)id));
                CDODBUtil.sqlUpdate(stmt, true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            accessor.getStatementCache().releasePreparedStatement(stmt);
            throw throwable;
        }
        accessor.getStatementCache().releasePreparedStatement(stmt);
    }
}

