/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.net4j.util.collection.MoveableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateMoveableListWrapper
implements List<Object>,
MoveableList<Object> {
    private List<Object> delegate;

    public Object move(int targetIndex, int sourceIndex) {
        int size = this.size();
        if (sourceIndex >= size) {
            throw new IndexOutOfBoundsException("sourceIndex=" + sourceIndex + ", size=" + size);
        }
        if (targetIndex >= size) {
            throw new IndexOutOfBoundsException("targetIndex=" + targetIndex + ", size=" + size);
        }
        Object object = this.get(sourceIndex);
        if (targetIndex == sourceIndex) {
            return object;
        }
        if (targetIndex < sourceIndex) {
            this.moveUp1(targetIndex, sourceIndex - targetIndex);
        } else {
            this.moveDown1(targetIndex, targetIndex - sourceIndex);
        }
        this.set(targetIndex, object);
        return object;
    }

    private void moveUp1(int index, int count) {
        int i = count;
        while (i > 0) {
            this.set(index + i, this.get(index + i - 1));
            --i;
        }
    }

    private void moveDown1(int index, int count) {
        int i = count;
        while (i > 0) {
            this.set(index - i, this.get(index - i + 1));
            --i;
        }
    }

    public List<Object> getDelegate() {
        return this.delegate;
    }

    public void setDelegate(List<Object> delegate) {
        this.delegate = delegate;
    }

    protected Object getObject(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof CDOID)) {
            return o;
        }
        return HibernateUtil.getInstance().getCDORevision((CDOID)o);
    }

    protected List<Object> getObjects(List<?> cdoIDs) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object o : cdoIDs) {
            result.add(this.getObject(o));
        }
        return result;
    }

    protected CDOID getCDOID(Object o) {
        CDORevision cdoRevision = (CDORevision)o;
        return cdoRevision.getID();
    }

    protected List<CDOID> getCDOIDs(Collection<?> c) {
        ArrayList<CDOID> newC = new ArrayList<CDOID>();
        for (Object o : c) {
            newC.add(this.getCDOID(o));
        }
        return newC;
    }

    @Override
    public void add(int index, Object element) {
        this.getDelegate().add(index, this.getCDOID(element));
    }

    @Override
    public boolean add(Object o) {
        return this.getDelegate().add(this.getCDOID(o));
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        return this.getDelegate().addAll(this.getCDOIDs(c));
    }

    @Override
    public boolean addAll(int index, Collection<? extends Object> c) {
        return this.getDelegate().addAll(index, this.getCDOIDs(c));
    }

    @Override
    public void clear() {
        this.getDelegate().clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.getDelegate().contains(this.getCDOID(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getDelegate().containsAll(this.getCDOIDs(c));
    }

    @Override
    public Object get(int index) {
        return this.getObject(this.getDelegate().get(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.getDelegate().indexOf(this.getCDOID(o));
    }

    @Override
    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    @Override
    public Iterator<Object> iterator() {
        return new CDOHibernateIterator(this.getDelegate().iterator());
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getDelegate().lastIndexOf(this.getCDOID(o));
    }

    @Override
    public ListIterator<Object> listIterator() {
        return new CDOHibernateListIterator(this.getDelegate().listIterator());
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return new CDOHibernateListIterator(this.getDelegate().listIterator(index));
    }

    @Override
    public Object remove(int index) {
        return this.getDelegate().remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.getDelegate().remove(this.getCDOID(o));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.getDelegate().removeAll(this.getCDOIDs(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.getDelegate().retainAll(this.getCDOIDs(c));
    }

    @Override
    public Object set(int index, Object element) {
        return this.getDelegate().set(index, this.getCDOID(element));
    }

    @Override
    public int size() {
        return this.getDelegate().size();
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        return this.getObjects(this.getDelegate().subList(fromIndex, toIndex));
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int i = 0;
        for (Object o : this) {
            result[i++] = o;
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int i = 0;
        for (Object o : this) {
            a[i++] = o;
        }
        return a;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CDOHibernateIterator
    implements Iterator<Object> {
        private final Iterator<?> delegate;

        public CDOHibernateIterator(Iterator<?> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Object next() {
            Object o = this.delegate.next();
            if (o instanceof CDOID) {
                return HibernateUtil.getInstance().getCDORevision((CDOID)o);
            }
            return o;
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CDOHibernateListIterator
    implements ListIterator<Object> {
        private final ListIterator<Object> delegate;

        public CDOHibernateListIterator(ListIterator<Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void add(Object o) {
            this.delegate.add(((CDORevision)o).getID());
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        @Override
        public Object next() {
            Object o = this.delegate.next();
            if (o instanceof CDOID) {
                return HibernateUtil.getInstance().getCDORevision((CDOID)this.delegate.next());
            }
            return o;
        }

        @Override
        public int nextIndex() {
            return this.delegate.nextIndex();
        }

        @Override
        public Object previous() {
            Object o = this.delegate.previous();
            if (o instanceof CDOID) {
                return HibernateUtil.getInstance().getCDORevision((CDOID)this.delegate.next());
            }
            return o;
        }

        @Override
        public int previousIndex() {
            return this.delegate.previousIndex();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public void set(Object o) {
            this.delegate.set(((CDORevision)o).getID());
        }
    }
}

