/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDMeta;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.internal.server.PackageManager;
import org.eclipse.emf.cdo.internal.server.ResourceManager;
import org.eclipse.emf.cdo.internal.server.RevisionManager;
import org.eclipse.emf.cdo.internal.server.SessionManager;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IRepositoryElement;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repository
extends Container<IRepositoryElement>
implements IRepository {
    private String name;
    private IStore store;
    private String uuid;
    private Map<String, String> properties;
    private Boolean supportingRevisionDeltas;
    private Boolean supportingAudits;
    private Boolean verifyingRevisions;
    private PackageManager packageManager = this.createPackageManager();
    private SessionManager sessionManager = this.createSessionManager();
    private ResourceManager resourceManager = this.createResourceManager();
    private RevisionManager revisionManager = this.createRevisionManager();
    private IRepositoryElement[] elements;
    private transient long lastMetaID;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IStore getStore() {
        return this.store;
    }

    @Override
    public void setStore(IStore store) {
        this.store = store;
        store.setRepository(this);
    }

    @Override
    public String getUUID() {
        if (this.uuid == null) {
            String value = this.getProperties().get("overrideUUID");
            this.uuid = StringUtil.isEmpty((String)value) ? UUID.randomUUID().toString() : value;
        }
        return this.uuid;
    }

    @Override
    public synchronized Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    @Override
    public synchronized void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public boolean isSupportingRevisionDeltas() {
        if (this.supportingRevisionDeltas == null) {
            String value = this.getProperties().get("supportingRevisionDeltas");
            this.supportingRevisionDeltas = value == null ? false : Boolean.valueOf(value);
        }
        return this.supportingRevisionDeltas;
    }

    @Override
    public boolean isSupportingAudits() {
        if (this.supportingAudits == null) {
            String value = this.getProperties().get("supportingAudits");
            this.supportingAudits = value == null ? false : Boolean.valueOf(value);
        }
        return this.supportingAudits;
    }

    @Override
    public boolean isVerifyingRevisions() {
        if (this.verifyingRevisions == null) {
            String value = this.getProperties().get("verifyingRevisions");
            this.verifyingRevisions = value == null ? false : Boolean.valueOf(value);
        }
        return this.verifyingRevisions;
    }

    @Override
    public PackageManager getPackageManager() {
        return this.packageManager;
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public RevisionManager getRevisionManager() {
        return this.revisionManager;
    }

    public IRepositoryElement[] getElements() {
        return this.elements;
    }

    public boolean isEmpty() {
        return false;
    }

    @Override
    public synchronized CDOIDMetaRange getMetaIDRange(int count) {
        CDOIDMeta lowerBound = CDOIDUtil.createMeta((long)(this.lastMetaID + 1L));
        this.lastMetaID += (long)count;
        return CDOIDUtil.createMetaRange((CDOID)lowerBound, (int)count);
    }

    @Override
    public long getLastMetaID() {
        return this.lastMetaID;
    }

    public void setLastMetaID(long lastMetaID) {
        this.lastMetaID = lastMetaID;
    }

    public String toString() {
        return MessageFormat.format("Repository[{0}]", this.name);
    }

    protected PackageManager createPackageManager() {
        return new PackageManager(this);
    }

    protected SessionManager createSessionManager() {
        return new SessionManager(this);
    }

    protected ResourceManager createResourceManager() {
        return new ResourceManager(this);
    }

    protected RevisionManager createRevisionManager() {
        return new RevisionManager(this);
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (StringUtil.isEmpty((String)this.name)) {
            throw new IllegalArgumentException("name is null or empty");
        }
        if (this.store == null) {
            throw new IllegalArgumentException("store is null");
        }
        if (this.isSupportingRevisionDeltas() && !this.store.hasWriteDeltaSupport()) {
            throw new IllegalStateException("Store without revision delta support");
        }
        if (this.isSupportingAudits() && !this.store.hasAuditingSupport()) {
            throw new IllegalStateException("Store without auditing support");
        }
        this.elements = new IRepositoryElement[]{this.packageManager, this.sessionManager, this.resourceManager, this.revisionManager, this.store};
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.activateRepository();
    }

    protected void doDeactivate() throws Exception {
        this.deactivateRepository();
        super.doDeactivate();
    }

    protected void activateRepository() throws Exception {
        LifecycleUtil.activate((Object)this.store);
        LifecycleUtil.activate((Object)this.packageManager);
        if (this.store.wasCrashed()) {
            this.store.repairAfterCrash();
        }
        this.setLastMetaID(this.store.getLastMetaID());
        LifecycleUtil.activate((Object)this.sessionManager);
        LifecycleUtil.activate((Object)this.resourceManager);
        LifecycleUtil.activate((Object)this.revisionManager);
    }

    protected void deactivateRepository() {
        LifecycleUtil.deactivate((Object)this.revisionManager);
        LifecycleUtil.deactivate((Object)this.resourceManager);
        LifecycleUtil.deactivate((Object)this.sessionManager);
        LifecycleUtil.deactivate((Object)this.packageManager);
        LifecycleUtil.deactivate((Object)this.store);
    }
}

