/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.internal.server.SessionManager;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IResourceManager;
import org.eclipse.emf.cdo.server.IStoreReader;
import org.eclipse.emf.cdo.server.StoreUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class ResourceManager
extends Lifecycle
implements IResourceManager {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SESSION, SessionManager.class);
    private Repository repository;
    private Map<CDOID, String> idToPathMap = new HashMap<CDOID, String>();
    private Map<String, CDOID> pathToIDMap = new HashMap<String, CDOID>();

    public ResourceManager(Repository repository) {
        this.repository = repository;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public CDOID getResourceID(String path) {
        CDOID id = this.pathToIDMap.get(path);
        if (id == null && (id = this.loadID(path)) != null) {
            this.registerResource(id, path);
        }
        return id;
    }

    public String getResourcePath(CDOID id) {
        String path = this.idToPathMap.get(id);
        if (path == null && (path = this.loadPath(id)) != null) {
            this.registerResource(id, path);
        }
        return path;
    }

    public void registerResource(CDOID id, String path) {
        if (TRACER.isEnabled()) {
            TRACER.format("Registering resource: {0} <--> {1}", new Object[]{id, path});
        }
        this.idToPathMap.put(id, path);
        this.pathToIDMap.put(path, id);
    }

    private CDOID loadID(String path) {
        IStoreReader storeReader = StoreUtil.getReader();
        return storeReader.readResourceID(path);
    }

    private String loadPath(CDOID id) {
        IStoreReader storeReader = StoreUtil.getReader();
        return storeReader.readResourcePath(id);
    }
}

