/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOClassProxy;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.internal.server.LongIDStore;
import org.eclipse.emf.cdo.internal.server.Store;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IStoreWriter;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.spi.common.InternalCDOClass;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class StoreAccessor
implements IStoreAccessor {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, StoreAccessor.class);
    private Store store;
    private Object context;
    private boolean reader;

    private StoreAccessor(Store store, Object context, boolean reader) {
        this.store = store;
        this.context = context;
        this.reader = reader;
    }

    protected StoreAccessor(Store store, ISession session) {
        this(store, session, true);
    }

    protected StoreAccessor(Store store, IView view) {
        this(store, view, false);
    }

    public final void release() {
        this.store.releaseAccessor(this);
    }

    protected void doRelease() {
    }

    public Store getStore() {
        return this.store;
    }

    public boolean isReader() {
        return this.reader;
    }

    public ISession getSession() {
        if (this.context instanceof IView) {
            return ((IView)this.context).getSession();
        }
        return (ISession)this.context;
    }

    public IView getView() {
        if (this.context instanceof IView) {
            return (IView)this.context;
        }
        return null;
    }

    public InternalCDORevision verifyRevision(CDORevision revision) {
        return (InternalCDORevision)revision;
    }

    public void commit(IStoreWriter.CommitContext context) {
        if (TRACER.isEnabled()) {
            TRACER.format("Committing transaction: {0}", new Object[]{this.getView()});
        }
        this.writePackages(context.getNewPackages());
        this.addIDMappings(context);
        context.applyIDMappings();
        this.writeRevisions(context.getNewObjects());
        if (this.store.hasWriteDeltaSupport() && this.store.getRepository().isSupportingRevisionDeltas()) {
            this.writeRevisionDeltas(context.getDirtyObjectDeltas());
        } else {
            this.writeRevisions(context.getDirtyObjects());
        }
    }

    public void rollback(IStoreWriter.CommitContext context) {
        if (TRACER.isEnabled()) {
            TRACER.format("Rolling back transaction: {0}", new Object[]{this.getView()});
        }
    }

    protected void addIDMappings(IStoreWriter.CommitContext context) {
        if (this.store instanceof LongIDStore) {
            LongIDStore longIDStore = (LongIDStore)this.getStore();
            CDORevision[] cDORevisionArray = context.getNewObjects();
            int n = cDORevisionArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDORevision revision = cDORevisionArray[n2];
                CDOIDTemp oldID = (CDOIDTemp)revision.getID();
                CDOID newID = longIDStore.getNextCDOID();
                if (newID == null || newID.isNull() || newID.isTemporary()) {
                    throw new IllegalStateException("newID=" + newID);
                }
                context.addIDMapping(oldID, newID);
                ++n2;
            }
        }
    }

    protected void writePackages(CDOPackage ... cdoPackages) {
        CDOPackage[] cDOPackageArray = cdoPackages;
        int n = cdoPackages.length;
        int n2 = 0;
        while (n2 < n) {
            CDOPackage cdoPackage = cDOPackageArray[n2];
            this.writePackage(cdoPackage);
            ++n2;
        }
    }

    protected void writePackage(CDOPackage cdoPackage) {
        CDOClass[] cDOClassArray = cdoPackage.getClasses();
        int n = cDOClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOClass cdoClass = cDOClassArray[n2];
            this.writeClass((InternalCDOClass)cdoClass);
            ++n2;
        }
    }

    protected void writeClass(InternalCDOClass cdoClass) {
        for (CDOClassProxy superType : cdoClass.getSuperTypeProxies()) {
            this.writeSuperType(cdoClass, superType);
        }
        CDOFeature[] cDOFeatureArray = cdoClass.getFeatures();
        int n = cDOFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOFeature feature = cDOFeatureArray[n2];
            this.writeFeature(feature);
            ++n2;
        }
    }

    protected void writeSuperType(InternalCDOClass type, CDOClassProxy superType) {
        throw new UnsupportedOperationException();
    }

    protected void writeFeature(CDOFeature feature) {
        throw new UnsupportedOperationException();
    }

    protected void writeRevisions(CDORevision[] revisions) {
        CDORevision[] cDORevisionArray = revisions;
        int n = revisions.length;
        int n2 = 0;
        while (n2 < n) {
            CDORevision revision = cDORevisionArray[n2];
            this.writeRevision(revision);
            ++n2;
        }
    }

    protected void writeRevision(CDORevision revision) {
        throw new UnsupportedOperationException();
    }

    protected void writeRevisionDeltas(CDORevisionDelta[] revisionDeltas) {
        CDORevisionDelta[] cDORevisionDeltaArray = revisionDeltas;
        int n = revisionDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            CDORevisionDelta revisionDelta = cDORevisionDeltaArray[n2];
            this.writeRevisionDelta(revisionDelta);
            ++n2;
        }
    }

    protected void writeRevisionDelta(CDORevisionDelta revisionDelta) {
        throw new UnsupportedOperationException();
    }
}

