/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server;

import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.IStoreReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IStoreChunkReader {
    public IStoreReader getStoreReader();

    public CDORevision getRevision();

    public CDOFeature getFeature();

    public void addSimpleChunk(int var1);

    public void addRangedChunk(int var1, int var2);

    public List<Chunk> executeRead();

    public static class Chunk {
        private int startIndex;
        private Object ids;

        public Chunk(int startIndex) {
            this.startIndex = startIndex;
        }

        public Chunk(int startIndex, int size) {
            this(startIndex);
            this.ids = new CDOID[size];
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int size() {
            if (this.ids instanceof CDOID || this.ids == null) {
                return 1;
            }
            return ((CDOID[])this.ids).length;
        }

        public CDOID getID(int indexInChunk) {
            if (this.ids instanceof CDOID || this.ids == null) {
                if (indexInChunk == 0) {
                    return (CDOID)this.ids;
                }
                throw new ArrayIndexOutOfBoundsException(indexInChunk);
            }
            return ((CDOID[])this.ids)[indexInChunk];
        }

        public void addID(int indexInChunk, CDOID id) {
            if (this.ids instanceof CDOID || this.ids == null) {
                if (indexInChunk == 0) {
                    this.ids = id;
                    return;
                }
                throw new ArrayIndexOutOfBoundsException(indexInChunk);
            }
            ((CDOID[])this.ids)[indexInChunk] = id;
        }
    }
}

