/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.dialogs;

import org.eclipse.emf.cdo.internal.ui.SharedIcons;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.internal.cdo.util.FSMUtil;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.net4j.util.collection.IHistory;
import org.eclipse.net4j.util.collection.PreferenceHistory;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.widgets.HistoryText;
import org.eclipse.net4j.util.ui.widgets.PreferenceButton;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class OpenSessionDialog
extends TitleAreaDialog {
    public static final String TITLE = "Open Session";
    private IWorkbenchPage page;
    private IHistory<String> connectorHistory = new PreferenceHistory(OM.PREF_HISTORY_CONNECTORS);
    private IHistory<String> repositoryHistory = new PreferenceHistory(OM.PREF_HISTORY_REPOSITORIES);
    private HistoryText connectorText;
    private Label exampleLabel;
    private HistoryText repositoryText;
    private PreferenceButton automaticButton;
    private PreferenceButton legacyButton;
    private String serverDescription;
    private String repositoryName;
    private boolean automaticPackageRegistry;
    private boolean legacyModelSupport;

    static {
        OM.PREF_LEGACY_MODEL_SUPPORT.setValue((Object)FSMUtil.isLegacySystemAvailable());
    }

    public OpenSessionDialog(IWorkbenchPage page) {
        super(new Shell(page.getWorkbenchWindow().getShell()));
        this.page = page;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x400 | 0x20 | 0x10);
    }

    public IWorkbenchPage getPage() {
        return this.page;
    }

    public String getServerDescription() {
        return this.serverDescription;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public boolean isAutomaticPackageRegistry() {
        return this.automaticPackageRegistry;
    }

    public boolean isLegacyModelSupport() {
        return this.legacyModelSupport;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite((Composite)super.createDialogArea(parent), 0);
        composite.setLayoutData((Object)UIUtil.createGridData());
        composite.setLayout((Layout)new GridLayout(2, false));
        this.setTitle(TITLE);
        this.setTitleImage(SharedIcons.getImage("wizban/PackageManager"));
        new Label(composite, 0).setText("Server Description:");
        this.connectorText = new HistoryText(composite, 2052, this.connectorHistory);
        this.connectorText.getCombo().setLayoutData((Object)new GridData(4, 1, true, false));
        if (this.connectorHistory.isEmpty()) {
            new Label(composite, 0);
            this.exampleLabel = new Label(composite, 0);
            this.exampleLabel.setText("for example 'tcp://estepper@dev.eclipse.org:2036'");
            this.exampleLabel.setForeground(this.getShell().getDisplay().getSystemColor(16));
        }
        new Label(composite, 0).setText("Repository Name:");
        this.repositoryText = new HistoryText(composite, 2052, this.repositoryHistory);
        this.repositoryText.getCombo().setLayoutData((Object)new GridData(150, -1));
        new Label(composite, 0);
        this.automaticButton = new PreferenceButton(composite, 32, "Automatic Package Registry", OM.PREF_AUTOMATIC_PACKAGE_REGISTY);
        new Label(composite, 0);
        this.legacyButton = new PreferenceButton(composite, 32, "Legacy Model Support", OM.PREF_LEGACY_MODEL_SUPPORT);
        this.legacyButton.getButton().setEnabled(FSMUtil.isLegacySystemAvailable());
        this.connectorText.setFocus();
        this.connectorText.getCombo().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (OpenSessionDialog.this.exampleLabel != null) {
                    OpenSessionDialog.this.exampleLabel.setVisible(true);
                }
            }

            public void focusLost(FocusEvent e) {
                if (OpenSessionDialog.this.exampleLabel != null) {
                    OpenSessionDialog.this.exampleLabel.setVisible(false);
                }
            }
        });
        return composite;
    }

    protected void okPressed() {
        this.serverDescription = this.connectorText.getText(true);
        this.repositoryName = this.repositoryText.getText(true);
        this.automaticPackageRegistry = this.automaticButton.getSelection(true);
        this.legacyModelSupport = this.legacyButton.getSelection(true);
        super.okPressed();
    }

    public void closeWithSuccess() {
    }
}

