/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.transaction;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.transaction.CDOSavepoint;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.CDOTransactionStrategy;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.net4j.util.om.monitor.EclipseMonitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.transaction.TransactionException;

public class CDOSingleTransactionStrategyImpl
implements CDOTransactionStrategy {
    public static final CDOSingleTransactionStrategyImpl INSTANCE = new CDOSingleTransactionStrategyImpl();
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_TRANSCTION, CDOSingleTransactionStrategyImpl.class);

    public void commit(InternalCDOTransaction transaction, IProgressMonitor progressMonitor) throws Exception {
        InternalCDOTransaction.InternalCDOCommitContext commitContext = transaction.createCommitContext();
        if (TRACER.isEnabled()) {
            TRACER.format("CDOCommitContext.preCommit", new Object[0]);
        }
        commitContext.preCommit();
        CDOSessionProtocol.CommitTransactionResult result = null;
        if (commitContext.getTransaction().isDirty()) {
            EclipseMonitor monitor = new EclipseMonitor(progressMonitor);
            result = transaction.getSession().getSessionProtocol().commitTransaction(commitContext, (OMMonitor)monitor);
            String rollbackMessage = result.getRollbackMessage();
            if (rollbackMessage != null) {
                throw new TransactionException(rollbackMessage);
            }
        }
        if (TRACER.isEnabled()) {
            TRACER.format("CDOCommitContext.postCommit", new Object[0]);
        }
        commitContext.postCommit(result);
    }

    public void rollback(InternalCDOTransaction transaction, CDOSavepoint savepoint) {
        transaction.handleRollback(savepoint);
    }

    public CDOSavepoint setSavepoint(InternalCDOTransaction transaction) {
        return transaction.handleSetSavepoint();
    }

    public void setTarget(InternalCDOTransaction transaction) {
    }

    public void unsetTarget(InternalCDOTransaction transaction) {
    }
}

