/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.ocl;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ocl.helper.HelperUtil;
import org.eclipse.emf.ocl.helper.IOCLHelper;
import org.eclipse.emf.ocl.helper.OCLParsingException;
import org.eclipse.emf.ocl.parser.EnvironmentFactory;
import org.eclipse.emf.ocl.query.Query;
import org.eclipse.emf.ocl.query.QueryFactory;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.helper.OCLHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOCLModelConstraint<C, CT, CLS, E>
implements IModelConstraint {
    private final IConstraintDescriptor descriptor;
    private final Map<EClass, Reference<?>> queries = new WeakHashMap();
    private QueryManager queryManager;

    public AbstractOCLModelConstraint(IConstraintDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    protected org.eclipse.ocl.EnvironmentFactory<?, C, ?, ?, ?, ?, ?, ?, ?, CT, CLS, E> createOCLEnvironmentFactory() {
        return null;
    }

    @Deprecated
    protected EnvironmentFactory createEnvironmentFactory() {
        return EnvironmentFactory.ECORE_INSTANCE;
    }

    public org.eclipse.ocl.Query<C, CLS, E> getConstraintCondition(EObject target) {
        org.eclipse.ocl.Query result = null;
        EClass eClass = target.eClass();
        Reference<?> reference = this.queries.get(eClass);
        if (reference != null) {
            result = (org.eclipse.ocl.Query)reference.get();
        }
        if (result == null) {
            OCL ocl = OCL.newInstance(this.createOCLEnvironmentFactory());
            OCLHelper helper = ocl.createOCLHelper();
            helper.setInstanceContext((Object)target);
            try {
                result = ocl.createQuery(helper.createInvariant(this.getDescriptor().getBody()));
            }
            catch (ParserException e) {
                throw new RuntimeException(e);
            }
            this.queries.put(eClass, new WeakReference<org.eclipse.ocl.Query>(result));
        }
        return result;
    }

    @Deprecated
    public Query getCondition(EClass eClass) {
        Query result = null;
        Reference<?> reference = this.queries.get(eClass);
        if (reference != null) {
            result = (Query)reference.get();
        }
        if (result == null) {
            IOCLHelper oclHelper = HelperUtil.createOCLHelper((EnvironmentFactory)this.createEnvironmentFactory());
            oclHelper.setContext((Object)eClass);
            try {
                result = QueryFactory.eINSTANCE.createQuery(oclHelper.createQuery(this.getDescriptor().getBody()));
            }
            catch (OCLParsingException e) {
                throw new RuntimeException(e);
            }
            this.queries.put(eClass, new WeakReference<Query>(result));
        }
        return result;
    }

    public IStatus validate(IValidationContext ctx) {
        EObject target = ctx.getTarget();
        if (this.getQueryManager().check(target)) {
            return ctx.createSuccessStatus();
        }
        return ctx.createFailureStatus(new Object[]{target});
    }

    private QueryManager getQueryManager() {
        if (this.queryManager == null) {
            this.queryManager = new QueryManager();
        }
        return this.queryManager;
    }

    public IConstraintDescriptor getDescriptor() {
        return this.descriptor;
    }

    private final class QueryManager {
        private final boolean isOldStyle;

        QueryManager() {
            this.isOldStyle = AbstractOCLModelConstraint.this.createOCLEnvironmentFactory() == null;
        }

        boolean check(EObject target) {
            if (this.isOldStyle) {
                Query query = AbstractOCLModelConstraint.this.getCondition(target.eClass());
                return query.check((Object)target);
            }
            org.eclipse.ocl.Query query = AbstractOCLModelConstraint.this.getConstraintCondition(target);
            return query.check((Object)target);
        }
    }
}

