/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IOUtil;

public final class ZIPUtil {
    public static final int DEFALULT_BUFFER_SIZE = 4096;
    private static final int ORDER_KEEP = -1;
    private static final int ORDER_SWAP = 1;

    private ZIPUtil() {
    }

    /*
     * Unable to fully structure code
     */
    public static void zip(ZipEntryHandler handler, File zipFile) throws IORuntimeException {
        block10: {
            buffer = new byte[4096];
            context = new EntryContext();
            fos = IOUtil.openOutputStream(zipFile);
            zos = null;
            input = null;
            entry = null;
            try {
                try {
                    zos = new ZipOutputStream(new BufferedOutputStream(fos, 4096));
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        handler.handleEntry(context);
                        if (context.isEmpty()) break block10;
                        try {
                            name = context.getName().replace(File.separatorChar, '/');
                            entry = new ZipEntry(name);
                            zos.putNextEntry(entry);
                            if (context.isDirectory()) ** GOTO lbl-1000
                            input = context.getInputStream();
                            if (input == null) {
                                throw new IllegalStateException("Input is null for zip entry " + name);
                            }
                            IOUtil.copy(input, (OutputStream)zos, buffer);
                        }
                        finally {
                            IOUtil.closeSilent(input);
                            if (entry != null) {
                                zos.closeEntry();
                            }
                            context.reset();
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ex) {
                    throw new IORuntimeException(ex);
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var10_11) {
                IOUtil.closeSilent(zos);
                IOUtil.closeSilent(fos);
                throw var10_11;
            }
        }
        IOUtil.closeSilent(zos);
        IOUtil.closeSilent(fos);
    }

    public static void zip(File sourceFolder, boolean excludeRoot, File zipFile) {
        ZIPUtil.zip(new FileSystemZipHandler(sourceFolder, excludeRoot), zipFile);
    }

    public static void unzip(File zipFile, UnzipHandler handler) throws IORuntimeException {
        FileInputStream fis = IOUtil.openInputStream(zipFile);
        ZipInputStream zis = null;
        try {
            try {
                ZipEntry entry;
                zis = new ZipInputStream(new BufferedInputStream(fis, 4096));
                while ((entry = zis.getNextEntry()) != null) {
                    if (entry.isDirectory()) {
                        handler.unzipDirectory(entry.getName());
                        continue;
                    }
                    handler.unzipFile(entry.getName(), zis);
                }
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(zis);
            IOUtil.closeSilent(fis);
            throw throwable;
        }
        IOUtil.closeSilent(zis);
        IOUtil.closeSilent(fis);
    }

    public static void unzip(File zipFile, File targetFolder) throws IORuntimeException {
        ZIPUtil.unzip(zipFile, new FileSystemUnzipHandler(targetFolder, 4096));
    }

    public static final class EntryContext {
        private static final String EMPTY = new String();
        private String name = EMPTY;
        private InputStream inputStream;
        private boolean directory;

        EntryContext() {
        }

        void reset() {
            this.name = null;
            this.inputStream = null;
        }

        boolean isEmpty() {
            return this.name == null;
        }

        boolean isDirectory() {
            return this.directory;
        }

        String getName() {
            return this.name;
        }

        InputStream getInputStream() {
            return this.inputStream;
        }

        public void setName(String name, boolean directory) {
            this.name = String.valueOf(name) + (directory ? "/" : "");
            this.directory = directory;
        }

        public void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }
    }

    public static final class FileSystemUnzipHandler
    implements UnzipHandler {
        private File targetFolder;
        private transient byte[] buffer;

        public FileSystemUnzipHandler(File targetFolder, int bufferSize) {
            this.targetFolder = targetFolder;
            this.buffer = new byte[bufferSize];
        }

        public File getTargetFolder() {
            return this.targetFolder;
        }

        public void unzipDirectory(String name) {
            File directory = new File(this.targetFolder, name);
            if (!directory.exists()) {
                directory.mkdirs();
            }
        }

        public void unzipFile(String name, InputStream zipStream) {
            File targetFile = new File(this.targetFolder, name);
            if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
            FileOutputStream out = IOUtil.openOutputStream(targetFile);
            try {
                IOUtil.copy(zipStream, (OutputStream)out, this.buffer);
            }
            finally {
                IOUtil.closeSilent(out);
            }
        }
    }

    public static final class FileSystemZipHandler
    implements ZipEntryHandler {
        private int sourceFolderLength;
        private transient Iterator<File> files;

        public FileSystemZipHandler(File sourceFolder, boolean excludeRoot) {
            File root = excludeRoot ? sourceFolder : sourceFolder.getParentFile();
            this.sourceFolderLength = root.getAbsolutePath().length();
            if (excludeRoot) {
                ++this.sourceFolderLength;
            }
            final int baseLength = sourceFolder.getAbsolutePath().length();
            List<File> list = IOUtil.listBreadthFirst(sourceFolder);
            Collections.sort(list, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    String path1 = this.getPath(f1, baseLength);
                    String path2 = this.getPath(f2, baseLength);
                    if (path1.length() == 0) {
                        return -1;
                    }
                    if (path2.length() == 0) {
                        return 1;
                    }
                    if (f1.isDirectory()) {
                        if (f2.isDirectory()) {
                            if (path1.equalsIgnoreCase("/META-INF")) {
                                return -1;
                            }
                            if (path2.equalsIgnoreCase("/META-INF")) {
                                return 1;
                            }
                            return path1.compareTo(path2);
                        }
                        if (path1.equalsIgnoreCase("/META-INF")) {
                            return -1;
                        }
                        if (path2.equalsIgnoreCase("/META-INF/MANIFEST.MF")) {
                            return 1;
                        }
                        return -1;
                    }
                    if (f2.isDirectory()) {
                        if (path2.equalsIgnoreCase("/META-INF")) {
                            return 1;
                        }
                        if (path1.equalsIgnoreCase("/META-INF/MANIFEST.MF")) {
                            return -1;
                        }
                        return 1;
                    }
                    if (path1.equalsIgnoreCase("/META-INF/MANIFEST.MF")) {
                        return -1;
                    }
                    if (path2.equalsIgnoreCase("/META-INF/MANIFEST.MF")) {
                        return 1;
                    }
                    return path1.compareTo(path2);
                }

                private String getPath(File file, int baseLength2) {
                    String absolutePath = file.getAbsolutePath();
                    String substring = absolutePath.substring(baseLength2);
                    String replace = substring.replace(File.separatorChar, '/');
                    return replace;
                }
            });
            this.files = list.iterator();
            if (excludeRoot) {
                this.files.next();
            }
        }

        public void handleEntry(EntryContext context) throws IOException {
            File file;
            String name;
            if (this.files.hasNext() && (name = this.getName(file = this.files.next())).length() != 0) {
                context.setName(name, file.isDirectory());
                if (file.isFile()) {
                    context.setInputStream(IOUtil.openInputStream(file));
                }
            }
        }

        protected String getName(File file) {
            return file.getAbsolutePath().substring(this.sourceFolderLength);
        }
    }

    public static interface UnzipHandler {
        public void unzipDirectory(String var1) throws IOException;

        public void unzipFile(String var1, InputStream var2) throws IOException;
    }

    public static interface ZipEntryHandler {
        public void handleEntry(EntryContext var1) throws IOException;
    }
}

