/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.marker.tests;

import java.util.Collection;
import java.util.Collections;
import junit.framework.Test;
import junit.framework.TestSuite;
import ordersystem.Order;
import ordersystem.OrderSystemFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.internal.service.impl.tests.ConstraintDescriptorTest;
import org.eclipse.emf.validation.internal.util.XmlConstraintDescriptor;
import org.eclipse.emf.validation.marker.MarkerUtil;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.model.ModelConstraint;
import org.eclipse.emf.validation.service.ConstraintExistsException;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.validation.tests.TestBase;

public class MarkerUtilTest
extends TestBase {
    private IProject testProject;
    private IFile testFile;
    private Resource testResource;

    public MarkerUtilTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(MarkerUtilTest.class, "Marker Utility Tests");
    }

    public void test_createMarkersInPathWithSpaces_201788() {
        IStatus status = this.batchValidator.validate((Collection)this.testResource.getContents());
        MarkerUtilTest.assertTrue((status.getSeverity() >= 2 ? 1 : 0) != 0);
        try {
            MarkerUtil.createMarkers((IStatus)status);
        }
        catch (CoreException e) {
            MarkerUtilTest.fail((String)("Failed to create markers: " + e.getLocalizedMessage()));
        }
        try {
            IMarker[] markers = this.testFile.findMarkers("org.eclipse.emf.validation.problem", true, 0);
            MarkerUtilTest.assertFalse((String)"No markers created", (markers.length == 0 ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            MarkerUtilTest.fail((String)("Failed to find markers: " + e.getLocalizedMessage()));
        }
    }

    public void test_clearMarkersFromCleanResource_218765() {
        this.batchValidator.setOption(IBatchValidator.OPTION_TRACK_RESOURCES, (Object)Boolean.TRUE);
        IStatus status = this.batchValidator.validate((Collection)this.testResource.getContents());
        MarkerUtilTest.assertTrue((status.getSeverity() >= 2 ? 1 : 0) != 0);
        try {
            MarkerUtil.updateMarkers((IStatus)status);
        }
        catch (CoreException e) {
            MarkerUtilTest.fail((String)("Failed to create markers: " + e.getLocalizedMessage()));
        }
        EAnnotation annot = EcoreFactory.eINSTANCE.createEAnnotation();
        annot.setSource("clean");
        this.testResource.getContents().add((Object)annot);
        status = this.batchValidator.validate((EObject)annot);
        MarkerUtilTest.assertEquals((int)0, (int)status.getSeverity());
        try {
            MarkerUtil.updateMarkers((IStatus)status);
        }
        catch (CoreException e) {
            MarkerUtilTest.fail((String)("Failed to update markers: " + e.getLocalizedMessage()));
        }
        try {
            IMarker[] markers = this.testFile.findMarkers("org.eclipse.emf.validation.problem", true, 0);
            MarkerUtilTest.assertEquals((String)"Markers not cleared", (int)0, (int)markers.length);
        }
        catch (CoreException e) {
            MarkerUtilTest.fail((String)("Failed to find markers: " + e.getLocalizedMessage()));
        }
    }

    public void testMarkerCreationOnNestedStatus_295841() {
        ModelConstraint constraint;
        ConstraintDescriptorTest.FixtureElement config = ConstraintDescriptorTest.newFixtureConfig();
        config.putAttribute("id", "aGetConOpTest@" + System.identityHashCode(config)).putAttribute("mode", EvaluationMode.BATCH.getName());
        try {
            constraint = new ModelConstraint((IConstraintDescriptor)new XmlConstraintDescriptor((IConfigurationElement)config)){

                public IStatus validate(IValidationContext ctx) {
                    return Status.CANCEL_STATUS;
                }
            };
        }
        catch (ConstraintExistsException e) {
            throw new RuntimeException(e);
        }
        EObject target = (EObject)this.testResource.getContents().get(0);
        ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH).validate((Object)target);
        ConstraintStatus status = new ConstraintStatus((IModelConstraint)constraint, target, "fail", null);
        MultiStatus ms1 = new MultiStatus("org.eclipse.validation", 0, new IStatus[]{new MultiStatus("org.eclipse.validation", 0, new IStatus[]{status}, "m2", null)}, "m1", null);
        try {
            MarkerUtil.createMarkers((IStatus)ms1);
            IMarker[] markers = this.testFile.findMarkers("org.eclipse.emf.validation.problem", true, 0);
            MarkerUtilTest.assertNotNull((Object)markers);
            MarkerUtilTest.assertEquals((int)1, (int)markers.length);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.testProject = ResourcesPlugin.getWorkspace().getRoot().getProject("_Validation_Test");
        this.testProject.create(null);
        this.testProject.open(null);
        String fileName = "dir with spaces/test file.xmi";
        this.testFile = this.testProject.getFile((IPath)new Path(fileName));
        URI uri = URI.createPlatformResourceURI((String)this.testFile.getFullPath().toString(), (boolean)true);
        ResourceSetImpl rset = new ResourceSetImpl();
        this.testResource = rset.createResource(uri);
        Order testOrder = OrderSystemFactory.eINSTANCE.createOrder();
        testOrder.setId("id");
        this.batchValidator.setIncludeLiveConstraints(true);
        this.batchValidator.setReportSuccesses(false);
        this.testResource.getContents().add((Object)testOrder);
        this.testResource.save(Collections.EMPTY_MAP);
    }

    protected void tearDown() throws Exception {
        this.testResource.unload();
        this.testResource = null;
        this.testProject.delete(true, true, null);
        this.testFile = null;
        this.testProject = null;
        super.tearDown();
    }
}

