/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.util.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.emf.validation.util.FilteredCollection;

public class FilteredCollectionTest
extends TestCase {
    private final Filter filter = new Filter();
    private final Collection<Integer> original = Arrays.asList(new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5));
    private final Collection<Integer> expectedFilteredResult = Arrays.asList(new Integer(0), new Integer(2), new Integer(4));
    private final FilteredCollection<Integer> filteredCollection = new FilteredCollection(this.original, (FilteredCollection.Filter)this.filter);

    public static Test suite() {
        return new TestSuite(FilteredCollectionTest.class);
    }

    public void test_getFilter() {
        FilteredCollectionTest.assertSame((Object)this.filter, (Object)this.filteredCollection.getFilter());
    }

    public void test_size() {
        FilteredCollectionTest.assertEquals((int)this.expectedFilteredResult.size(), (int)this.filteredCollection.size());
    }

    public void test_iterator() {
        FilteredCollectionTest.assertEquals(this.expectedFilteredResult, new ArrayList<Integer>((Collection<Integer>)this.filteredCollection));
        int i = 0;
        for (Integer next : this.filteredCollection) {
            FilteredCollectionTest.assertEquals((int)i, (int)next);
            i += 2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Filter
    implements FilteredCollection.Filter<Integer> {
        private Filter() {
        }

        public boolean accept(Integer element) {
            return element % 2 == 0;
        }
    }
}

