/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.widgets.settings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.eef.runtime.impl.utils.EEFUtils;
import org.eclipse.emf.eef.runtime.ui.widgets.settings.EEFEditorSettings;
import org.eclipse.emf.eef.runtime.ui.widgets.settings.EEFFilter;
import org.eclipse.emf.eef.runtime.ui.widgets.settings.NavigationStep;

public class EEFEditorSettingsBuilder {
    private EObject source;
    private EStructuralFeature feature;
    private List<NavigationStep> steps;

    public static EEFEditorSettingsBuilder create(EObject source, EStructuralFeature feature) {
        return new EEFEditorSettingsBuilder(source, feature);
    }

    private EEFEditorSettingsBuilder(EObject source, EStructuralFeature feature) {
        this.source = source;
        this.feature = feature;
        this.steps = new ArrayList<NavigationStep>();
    }

    public EEFEditorSettingsBuilder nextStep(NavigationStep step) {
        this.steps.add(step);
        return this;
    }

    public EEFEditorSettings build() {
        for (NavigationStep step : this.steps) {
            if (!step.getReference().isMany() || step.getIndex() != -1) continue;
            throw new IllegalStateException("Navigation step misconfigured : Reference " + step.getReference().getName() + " is mulivalued. You must define an index.");
        }
        return new EEFEditorSettingsImpl(this.source, this.feature, Collections.unmodifiableList(this.steps));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EEFEditorSettingsImpl
    implements EEFEditorSettings {
        private EObject source;
        private EStructuralFeature feature;
        private List<NavigationStep> steps;
        private EObject significantObject;

        private EEFEditorSettingsImpl(EObject source, EStructuralFeature feature, List<NavigationStep> steps) {
            this.source = source;
            this.feature = feature;
            this.steps = steps;
        }

        @Override
        public Object getValue() {
            EObject significantObject = this.getSignificantObject();
            if (significantObject != null && significantObject.eResource() != null) {
                return significantObject.eGet(this.feature);
            }
            return null;
        }

        public EObject getSignificantObject() {
            if (this.significantObject == null) {
                EObject current = this.source;
                for (NavigationStep step : this.steps) {
                    if (step.getReference().isMany()) {
                        ArrayList<EObject> result = (ArrayList<EObject>)current.eGet((EStructuralFeature)step.getReference());
                        ArrayList<EObject> result2 = new ArrayList<EObject>();
                        if (!(result.isEmpty() || step.getFilters().isEmpty() && step.getDiscriminator() == null)) {
                            if (!step.getFilters().isEmpty()) {
                                for (EEFFilter eefFilter : step.getFilters()) {
                                    for (EObject eObject : result) {
                                        if (!eefFilter.select(eObject)) continue;
                                        result2.add(eObject);
                                    }
                                    result = result2;
                                    result2 = new ArrayList();
                                }
                            }
                            if (step.getDiscriminator() != null) {
                                for (EObject eObject : result) {
                                    if (!step.getDiscriminator().isInstance((Object)eObject)) continue;
                                    result2.add(eObject);
                                }
                            }
                        }
                        if (result.isEmpty()) {
                            return null;
                        }
                        if (step.getIndex() != -1 && step.getIndex() < result.size()) {
                            current = (EObject)result.get(step.getIndex());
                            if (current != null) continue;
                            return null;
                        }
                        throw new IllegalStateException();
                    }
                    EObject current2 = current;
                    if ((current = (EObject)current2.eGet((EStructuralFeature)step.getReference())) != null) continue;
                    return null;
                }
                this.significantObject = current;
            }
            return this.significantObject;
        }

        public EObject getOrCreateSignificantObject() {
            if (this.significantObject == null || this.significantObject != null && this.significantObject.eResource() == null) {
                EObject current = this.source;
                for (NavigationStep step : this.steps) {
                    if (step.getReference().isMany()) {
                        ArrayList<EObject> result = (ArrayList<EObject>)current.eGet((EStructuralFeature)step.getReference());
                        ArrayList<EObject> result2 = new ArrayList<EObject>();
                        if (!(result.isEmpty() || step.getFilters().isEmpty() && step.getDiscriminator() == null)) {
                            if (!step.getFilters().isEmpty()) {
                                for (EEFFilter eefFilter : step.getFilters()) {
                                    for (EObject eObject : result) {
                                        if (!eefFilter.select(eObject)) continue;
                                        result2.add(eObject);
                                    }
                                    result = result2;
                                    result2 = new ArrayList();
                                }
                            }
                            if (step.getDiscriminator() != null) {
                                for (EObject eObject : result) {
                                    if (!step.getDiscriminator().isInstance((Object)eObject)) continue;
                                    result2.add(eObject);
                                }
                                result = result2;
                                result2 = new ArrayList();
                            }
                        }
                        if (result.isEmpty() && step.getInit() != null) {
                            result.add(step.getInit().init(current));
                        }
                        if (step.getIndex() != -1 && step.getIndex() < result.size()) {
                            current = (EObject)result.get(step.getIndex());
                            if (current != null || step.getInit() == null) continue;
                            EObject current2 = current;
                            current = step.getInit().init(current2);
                            continue;
                        }
                        throw new IllegalStateException();
                    }
                    EObject current2 = current;
                    if ((current = (EObject)current2.eGet((EStructuralFeature)step.getReference())) != null || step.getInit() == null) continue;
                    current = step.getInit().init(current2);
                }
                this.significantObject = current;
            }
            return this.significantObject;
        }

        public void setValue(Object newValue) {
            this.getOrCreateSignificantObject().eSet(this.feature, newValue);
        }

        @Override
        public Object choiceOfValues(AdapterFactory adapterFactory) {
            return this.feature instanceof EReference ? EEFUtils.choiceOfValues(this.source, this.feature) : null;
        }

        @Override
        public boolean isAffectingFeature(EStructuralFeature feature) {
            for (NavigationStep step : this.steps) {
                if (!step.getReference().equals(feature)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isAffectingEvent(Notification notification) {
            return notification.getFeature() instanceof EStructuralFeature && this.isAffectingFeature((EStructuralFeature)notification.getFeature()) || this.getSignificantObject() != null && this.getSignificantObject().equals(notification.getNotifier());
        }

        @Override
        public EObject getSource() {
            return this.source;
        }

        @Override
        public EClassifier getEType() {
            return this.feature.getEType();
        }

        @Override
        public EReference getLastReference() {
            if (this.feature instanceof EReference) {
                return (EReference)this.feature;
            }
            if (this.steps.size() > 0) {
                return this.steps.get(this.steps.size() - 1).getReference();
            }
            return null;
        }
    }
}

