/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.export;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpacePlugin;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.export.StateSpaceExporter;

public class AUTStateSpaceExporter
implements StateSpaceExporter {
    @Override
    public void export(StateSpace stateSpace, URI uri, IProgressMonitor monitor) throws IOException {
        File file = new File(uri.toFileString());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file), 65536);
        OutputStreamWriter writer = new OutputStreamWriter(out);
        if (stateSpace.getInitialStates().size() != 1) {
            StateSpacePlugin.INSTANCE.logError("AUT format can encode only state spaces with exactly one initial state!", null);
            if (stateSpace.getInitialStates().isEmpty()) {
                throw new IOException();
            }
        }
        int initial = ((State)stateSpace.getInitialStates().get(0)).getIndex();
        int states = stateSpace.getStates().size();
        int transitions = stateSpace.getTransitionCount();
        monitor.beginTask("Exporting state space...", states + 1);
        writer.write("des (" + initial + "," + transitions + "," + states + ")\n");
        monitor.worked(1);
        EList<State> statesList = stateSpace.getStates();
        int source = 0;
        while (source < states) {
            for (Transition transition : ((State)statesList.get(source)).getOutgoing()) {
                writer.write("(" + source + ",");
                writer.write("\"" + transition.getLabel() + "\",");
                writer.write(String.valueOf(transition.getTarget().getIndex()) + ")\n");
            }
            monitor.worked(1);
            if (monitor.isCanceled()) break;
            ++source;
        }
        writer.close();
        if (!monitor.isCanceled()) {
            monitor.done();
        }
    }

    @Override
    public String getName() {
        return "CADP";
    }

    @Override
    public String[] getFileExtensions() {
        return new String[]{"aut"};
    }
}

