/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.resource;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateEqualityHelper;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceFactory;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.impl.ModelImpl;
import org.eclipse.emf.henshin.statespace.resource.StateSpaceResource;

public class StateSpaceDeserializer {
    private InputStream in;

    public void read(StateSpaceResource resource, InputStream in) throws IOException {
        this.in = in;
        StateSpace stateSpace = StateSpaceFactory.eINSTANCE.createStateSpace();
        int marker = this.readShort();
        if (marker != 18515) {
            throw new IOException("State space file marker not found");
        }
        int version = this.readShort();
        if (version < 0 || version > 1) {
            throw new IOException("Unsupported format version: " + version);
        }
        int equalityType = this.readShort();
        StateEqualityHelper helper = StateSpaceFactory.eINSTANCE.createStateEqualityHelper();
        helper.setGraphEquality((equalityType & 1) == 1);
        helper.setIgnoreAttributes((equalityType & 2) == 2);
        helper.setIgnoreNodeIDs((equalityType & 4) == 4);
        stateSpace.setEqualityHelper(helper);
        int ruleCount = this.readShort();
        int stateCount = this.readInt();
        int transitionCount = this.readInt();
        int[] data = this.readData();
        stateSpace.setTransitionCount(transitionCount);
        stateSpace.setData(data);
        int i = 0;
        while (i < stateCount) {
            State state = StateSpaceFactory.eINSTANCE.createState();
            state.setIndex(i);
            stateSpace.getStates().add((Object)state);
            ++i;
        }
        i = 0;
        while (i < ruleCount) {
            URI uri = URI.createURI((String)this.readString());
            URI resolved = uri.resolve(resource.getURI());
            Rule rule = (Rule)resource.getResourceSet().getEObject(resolved, true);
            rule.eResource().setURI(uri.trimFragment());
            stateSpace.getRules().add((Object)rule);
            ++i;
        }
        transitionCount = 0;
        for (State state : stateSpace.getStates()) {
            String modelUri = this.readString();
            if (modelUri != null) {
                URI uri = URI.createURI((String)modelUri);
                URI resolved = uri.resolve(resource.getURI());
                Resource contents = resource.getResourceSet().getResource(resolved, true);
                contents.setURI(uri);
                ModelImpl model = new ModelImpl(contents);
                state.setModel(model);
                stateSpace.getInitialStates().add((Object)state);
            }
            state.setData(this.readData());
            if (state.isOpen()) {
                stateSpace.getOpenStates().add((Object)state);
            }
            int transitions = this.readShort();
            int i2 = 0;
            while (i2 < transitions) {
                Transition transition = StateSpaceFactory.eINSTANCE.createTransition();
                transition.setRule((Rule)stateSpace.getRules().get(this.readShort()));
                if (version == 0) {
                    transition.setMatch(this.readShort());
                } else if (version == 1) {
                    transition.setData(this.readData());
                }
                transition.setTarget((State)stateSpace.getStates().get(this.readInt()));
                state.getOutgoing().add((Object)transition);
                ++i2;
            }
            transitionCount += transitions;
        }
        stateSpace.setTransitionCount(transitionCount);
        if (in.read() >= 0) {
            throw new IOException("Expected end of file");
        }
        resource.getContents().clear();
        resource.getContents().add((Object)stateSpace);
        this.in = null;
    }

    private String readString() throws IOException {
        int size = this.readShort();
        if (size == 0) {
            return null;
        }
        char[] string = new char[size];
        int i = 0;
        while (i < size) {
            int value = this.in.read();
            if (value < 0) {
                throw new IOException("Unexpected end of file");
            }
            string[i] = (char)value;
            ++i;
        }
        return new String(string);
    }

    private int[] readData() throws IOException {
        int size = this.readShort();
        int[] data = new int[size];
        int i = 0;
        while (i < size) {
            data[i] = this.readInt();
            ++i;
        }
        return data;
    }

    private int readInt() throws IOException {
        int b0 = this.in.read();
        int b1 = this.in.read();
        int b2 = this.in.read();
        int b3 = this.in.read();
        if (b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0) {
            throw new IOException("Unexpected end of file");
        }
        return (b0 << 24) + ((b1 & 0xFF) << 16) + ((b2 & 0xFF) << 8) + (b3 & 0xFF);
    }

    private int readShort() throws IOException {
        int b0 = this.in.read();
        int b1 = this.in.read();
        if (b0 < 0 || b1 < 0) {
            throw new IOException("Unexpected end of file");
        }
        return (b0 << 8) + (b1 & 0xFF);
    }
}

