/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.Transition;

public class TransitionBendpointHelper {
    private static final int[][] EMPTY = new int[0][];

    public static int getBendpointDistance(Transition transition) {
        if (transition.getSource() == null || transition.getTarget() == null) {
            return 0;
        }
        List<Transition> connecting = TransitionBendpointHelper.getConnectingTransitions(transition.getSource(), transition.getTarget());
        if (connecting.size() == 1) {
            return 0;
        }
        int index = connecting.indexOf(transition);
        int d = (index / 2 + 1) * 15;
        if (index % 2 == 0) {
            d = -d;
        }
        return d;
    }

    public static int[][] getBendPoints(Transition transition) {
        if (transition.getSource() == null || transition.getTarget() == null) {
            return EMPTY;
        }
        if (transition.getSource() == transition.getTarget()) {
            return EMPTY;
        }
        int d = TransitionBendpointHelper.getBendpointDistance(transition);
        int[][] nArrayArray = new int[1][];
        int[] nArray = new int[4];
        nArray[1] = d;
        nArray[3] = d;
        nArrayArray[0] = nArray;
        return nArrayArray;
    }

    private static List<Transition> getConnectingTransitions(State s1, State s2) {
        if (s1.getIndex() > s2.getIndex()) {
            State tmp = s1;
            s1 = s2;
            s2 = tmp;
        }
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        transitions.addAll((Collection<Transition>)s1.getOutgoing());
        transitions.addAll((Collection<Transition>)s1.getIncoming());
        transitions.addAll((Collection<Transition>)s2.getOutgoing());
        transitions.addAll((Collection<Transition>)s2.getIncoming());
        int i = 0;
        while (i < transitions.size()) {
            State source = ((Transition)transitions.get(i)).getSource();
            State target = ((Transition)transitions.get(i)).getTarget();
            if (source != s1 && source != s2 || target != s1 && target != s2) {
                transitions.remove(i--);
            } else {
                int j = 0;
                while (j < i) {
                    if (transitions.get(i) == transitions.get(j)) {
                        transitions.remove(i--);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return transitions;
    }
}

