/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.commands;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.henshin.editor.commands.QuantUtil;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.util.HenshinRuleAnalysisUtil;

public class CreateMappingCommand
extends AbstractCommand {
    protected Node origin;
    protected Node image;
    protected Mapping mapping;
    protected Collection<?> affectedObjects;
    private boolean lhsRhsMapping = false;

    public CreateMappingCommand(Node source, Node target) {
        this.origin = source;
        this.image = target;
    }

    protected boolean prepare() {
        this.lhsRhsMapping = false;
        if (QuantUtil.anyNull(this.origin, this.image, this.origin.getGraph(), this.image.getGraph(), this.origin.getGraph().eContainer(), this.image.getGraph().eContainer()) || QuantUtil.allIdentical(this.origin.getGraph(), this.image.getGraph())) {
            return false;
        }
        if (this.isUnmappedLhsRhsPairFromSameRule(this.origin, this.image)) {
            this.lhsRhsMapping = true;
            return true;
        }
        return this.isMappableSourceAndNestedTargetNode(this.origin, this.image);
    }

    public void execute() {
        this.mapping = HenshinFactory.eINSTANCE.createMapping();
        this.mapping.setOrigin(this.origin);
        this.mapping.setImage(this.image);
        this.redo();
    }

    public void redo() {
        if (this.lhsRhsMapping) {
            this.origin.getGraph().getContainerRule().getMappings().add((Object)this.mapping);
        } else {
            NestedCondition nc = (NestedCondition)this.image.getGraph().eContainer();
            nc.getMappings().add((Object)this.mapping);
        }
        this.affectedObjects = Collections.singleton(this.mapping);
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        if (this.lhsRhsMapping) {
            this.origin.getGraph().getContainerRule().getMappings().remove((Object)this.mapping);
            this.affectedObjects = Collections.singleton(this.origin.getGraph().getContainerRule());
        } else {
            NestedCondition nc = (NestedCondition)this.image.getGraph().eContainer();
            nc.getMappings().remove((Object)this.mapping);
            this.affectedObjects = Collections.singleton(nc);
        }
    }

    public Collection<?> getAffectedObjects() {
        return this.affectedObjects;
    }

    protected boolean isUnmappedLhsRhsPairFromSameRule(Node source, Node target) {
        return HenshinRuleAnalysisUtil.isLHS((Graph)source.getGraph()) && HenshinRuleAnalysisUtil.isRHS((Graph)target.getGraph()) && source.getGraph().getContainerRule() == target.getGraph().getContainerRule() && this.isUnmapped(source, target, (Collection<Mapping>)source.getGraph().getContainerRule().getMappings());
    }

    protected boolean isUnmapped(Node sourceNode, Node targetNode, Collection<Mapping> mappings) {
        for (Mapping mapping : mappings) {
            if (mapping.getOrigin() != sourceNode && mapping.getImage() != targetNode) continue;
            return false;
        }
        return true;
    }

    private boolean isMappableSourceAndNestedTargetNode(Node sourceNode, Node targetNode) {
        if (targetNode.getGraph().eContainer() instanceof NestedCondition) {
            NestedCondition nc = (NestedCondition)targetNode.getGraph().eContainer();
            return this.isUnmapped(sourceNode, targetNode, (Collection<Mapping>)nc.getMappings());
        }
        return false;
    }

    protected static interface ModelConnectionStrategy {
        public void makeContained();

        public Collection<?> makeUncontained();
    }
}

