/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.external.prism;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.external.prism.AbstractPRISMTool;
import org.eclipse.emf.henshin.statespace.validation.ValidationResult;

public class PRISMStateSpaceValidator
extends AbstractPRISMTool {
    public ValidationResult validate(StateSpace stateSpace, IProgressMonitor monitor) throws Exception {
        String line;
        monitor.beginTask("Validating CSL property...", -1);
        File cslFile = this.createTempFile("property", ".csl", this.property);
        monitor.subTask("Running PRISM...");
        Process process = this.invokePRISM(stateSpace, cslFile, null, monitor);
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String error = null;
        boolean parseError = false;
        StringBuffer result = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            System.out.println(line);
            if (line.length() == 0) {
                parseError = false;
                continue;
            }
            if (parseError) {
                error = String.valueOf(error) + "\n" + line;
            } else if (line.startsWith("Error")) {
                error = line;
                parseError = true;
            } else {
                result.append(String.valueOf(line) + "\n");
            }
            if (!monitor.isCanceled()) continue;
            process.destroy();
            return null;
        }
        monitor.done();
        return new ValidationResult(true, result.toString());
    }

    public String getName() {
        return "PRISM";
    }

    public boolean usesProperty() {
        return true;
    }
}

