/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.internal.change;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.internal.change.FeatureChange;

public class ManyFeatureChange
implements FeatureChange {
    private Collection<Object> valueList;
    private Collection<Object> removedElements;
    private Collection<Object> addedElements;

    public ManyFeatureChange(EObject owner, EStructuralFeature feature) {
        this.valueList = (List)owner.eGet(feature);
        this.removedElements = new LinkedHashSet<Object>();
        this.addedElements = new LinkedHashSet<Object>();
    }

    @Override
    public void addValue(Object value) {
        this.addedElements.add(value);
    }

    @Override
    public void removeValue(Object value) {
        this.removedElements.add(value);
    }

    @Override
    public void execute() {
        for (Object removedObject : this.removedElements) {
            this.valueList.remove(removedObject);
        }
        for (Object addedObject : this.addedElements) {
            this.valueList.add(addedObject);
        }
    }

    @Override
    public void undo() {
        for (Object addedObject : this.addedElements) {
            this.valueList.remove(addedObject);
        }
        for (Object removedObject : this.removedElements) {
            this.valueList.add(removedObject);
        }
    }
}

