/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.matching.constraints;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.henshin.matching.constraints.AttributeConstraint;
import org.eclipse.emf.henshin.matching.constraints.DanglingConstraint;
import org.eclipse.emf.henshin.matching.constraints.ParameterConstraint;
import org.eclipse.emf.henshin.matching.constraints.ReferenceConstraint;
import org.eclipse.emf.henshin.matching.constraints.TypeConstraint;

public class Variable {
    private TypeConstraint typeConstraint;
    private Collection<AttributeConstraint> attributeConstraints;
    private Collection<DanglingConstraint> danglingConstraints;
    private Collection<ReferenceConstraint> referenceConstraints;
    private Collection<ParameterConstraint> parameterConstraints;

    public Variable(EClass type) {
        this.typeConstraint = new TypeConstraint(type);
        this.attributeConstraints = new HashSet<AttributeConstraint>();
        this.danglingConstraints = new HashSet<DanglingConstraint>();
        this.referenceConstraints = new HashSet<ReferenceConstraint>();
        this.parameterConstraints = new HashSet<ParameterConstraint>();
    }

    public void addConstraint(AttributeConstraint constraint) {
        this.attributeConstraints.add(constraint);
    }

    public void addConstraint(DanglingConstraint constraint) {
        this.danglingConstraints.add(constraint);
    }

    public void addConstraint(ReferenceConstraint constraint) {
        this.referenceConstraints.add(constraint);
    }

    public void addConstraint(ParameterConstraint constraint) {
        this.parameterConstraints.add(constraint);
    }

    public TypeConstraint getTypeConstraint() {
        return this.typeConstraint;
    }

    public Collection<AttributeConstraint> getAttributeConstraints() {
        return this.attributeConstraints;
    }

    public Collection<DanglingConstraint> getDanglingConstraints() {
        return this.danglingConstraints;
    }

    public Collection<ReferenceConstraint> getReferenceConstraints() {
        return this.referenceConstraints;
    }

    public Collection<ParameterConstraint> getParameterConstraints() {
        return this.parameterConstraints;
    }
}

