/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;

public class StateSpaceExplorationHelper {
    private final StateSpaceManager manager;
    private int expectedDuration;
    private int lastDuration;
    private int blockSize;
    private List<State> nextStates;
    private boolean generateLocations;
    private int steps;
    private double[] lastSpeeds;

    public StateSpaceExplorationHelper(StateSpaceManager manager) {
        this.lastDuration = this.expectedDuration = 500;
        this.blockSize = 10;
        this.manager = manager;
        this.generateLocations = false;
        this.nextStates = new ArrayList<State>();
        this.lastSpeeds = new double[10];
        this.steps = 0;
    }

    public boolean doExplorationStep() throws StateSpaceException {
        long startTime = System.currentTimeMillis();
        double speedChange = this.rangeCheck((double)this.expectedDuration / (double)this.lastDuration, 0.1, 10.0);
        this.blockSize = this.rangeCheck((int)((double)this.blockSize * speedChange), 3, 1000);
        this.filterNextStates();
        if (this.nextStates.size() < this.blockSize) {
            for (State open : this.manager.getStateSpace().getOpenStates()) {
                if (!this.nextStates.contains(open)) {
                    this.nextStates.add(open);
                }
                if (this.nextStates.size() < 2 * this.blockSize) continue;
                this.filterNextStates();
                if (this.nextStates.size() >= this.blockSize) break;
            }
        }
        this.filterNextStates();
        if (this.nextStates.isEmpty()) {
            return false;
        }
        List<State> exploreNow = this.nextStates.size() <= this.blockSize ? this.nextStates : this.nextStates.subList(0, this.blockSize);
        List<State> result = this.manager.exploreStates(exploreNow, this.generateLocations);
        this.nextStates.addAll(0, result);
        this.lastDuration = this.rangeCheck((int)(System.currentTimeMillis() - startTime), 1, 10 * this.expectedDuration);
        this.lastSpeeds[this.steps % this.lastSpeeds.length] = 1000.0 * (double)this.blockSize / (double)this.lastDuration;
        ++this.steps;
        return true;
    }

    private void filterNextStates() {
        int maxStateDistance = this.manager.getStateSpace().getMaxStateDistance();
        int i = 0;
        while (i < this.nextStates.size()) {
            if (!this.nextStates.get(i).isOpen()) {
                this.nextStates.remove(i--);
            } else if (maxStateDistance >= 0 && maxStateDistance <= this.manager.getStateDistance(this.nextStates.get(i))) {
                this.nextStates.remove(i--);
            }
            ++i;
        }
    }

    private int rangeCheck(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    private double rangeCheck(double value, double min, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    public StateSpaceManager getStateSpaceManager() {
        return this.manager;
    }

    public void setStepDuration(int stepDuration) {
        this.expectedDuration = stepDuration;
    }

    public void setGenerateLocations(boolean generateLocations) {
        this.generateLocations = generateLocations;
    }

    public double getCurrentSpeed() {
        if (this.steps <= 0) {
            return 0.0;
        }
        double speed = 0.0;
        int count = Math.min(this.steps, this.lastSpeeds.length);
        int i = 0;
        while (i < count) {
            speed += this.lastSpeeds[i];
            ++i;
        }
        return speed / (double)count;
    }
}

