/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.actions;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.henshin.editor.commands.QuantUtil;
import org.eclipse.emf.henshin.model.AmalgamationUnit;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.util.HenshinRuleAnalysisUtil;
import org.eclipse.jface.viewers.IStructuredSelection;

public class DeleteAction
extends org.eclipse.emf.edit.ui.action.DeleteAction {
    public DeleteAction(boolean deleteAllReferences) {
        super(deleteAllReferences);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        if (this.selectionContainsMappedKernel(selection)) {
            return false;
        }
        return super.updateSelection(selection);
    }

    protected boolean selectionContainsMappedKernel(IStructuredSelection selection) {
        for (Object object : selection) {
            Mapping mapping;
            DelegatingWrapperItemProvider wrapper;
            AmalgamationUnit aUnit;
            if (!(object instanceof DelegatingWrapperItemProvider) || (aUnit = this.getMultiWrappingAmalgamationsUnit(wrapper = (DelegatingWrapperItemProvider)object)) == null) continue;
            Object value = wrapper.getValue();
            if (value instanceof Node) {
                if (!this.isMappedNodeFromKernel(aUnit, (Node)value)) continue;
                return true;
            }
            if (value instanceof Edge) {
                Edge edge = (Edge)value;
                if (edge.getType() == null || !QuantUtil.noneNull(edge.getSource(), edge.getTarget()) || !this.isMappedNodeFromKernel(aUnit, edge.getSource()) || !this.isMappedNodeFromKernel(aUnit, edge.getTarget())) continue;
                Mapping sourceMapping = this.getMappingFromKernel(aUnit, edge.getSource());
                Mapping targetMapping = this.getMappingFromKernel(aUnit, edge.getTarget());
                for (Edge kernelEdge : sourceMapping.getOrigin().getOutgoing()) {
                    if (edge.getType() != kernelEdge.getType() || kernelEdge.getTarget() != targetMapping.getOrigin()) continue;
                    return true;
                }
                continue;
            }
            if (!(value instanceof Mapping) || !this.isMappedNodeFromKernel(aUnit, (mapping = (Mapping)value).getOrigin()) || !this.isMappedNodeFromKernel(aUnit, mapping.getImage()) || !this.isMappedIn(this.getMappingFromKernel(aUnit, mapping.getOrigin()).getOrigin(), this.getMappingFromKernel(aUnit, mapping.getImage()).getOrigin(), (Collection<Mapping>)aUnit.getKernelRule().getMappings())) continue;
            return true;
        }
        return false;
    }

    protected AmalgamationUnit getMultiWrappingAmalgamationsUnit(DelegatingWrapperItemProvider wrapper) {
        while (wrapper != null) {
            if (wrapper.getOwner() instanceof AmalgamationUnit) {
                if (wrapper.getFeature() == HenshinPackage.eINSTANCE.getAmalgamationUnit_MultiRules()) {
                    return (AmalgamationUnit)wrapper.getOwner();
                }
                return null;
            }
            if (wrapper.getOwner() instanceof DelegatingWrapperItemProvider) {
                wrapper = (DelegatingWrapperItemProvider)wrapper.getOwner();
                continue;
            }
            return null;
        }
        return null;
    }

    protected boolean isMappedIn(Node origin, Node image, Collection<Mapping> mappings) {
        for (Mapping m : mappings) {
            if (m.getOrigin() != origin || m.getImage() != image) continue;
            return true;
        }
        return false;
    }

    protected boolean isMappedNodeFromKernel(AmalgamationUnit aUnit, Node node) {
        return this.getMappingFromKernel(aUnit, node) != null;
    }

    protected Mapping getMappingFromKernel(AmalgamationUnit aUnit, Node node) {
        EList mappings;
        if (node == null || node.getGraph() == null) {
            return null;
        }
        if (HenshinRuleAnalysisUtil.isLHS((Graph)node.getGraph())) {
            mappings = aUnit.getLhsMappings();
        } else if (HenshinRuleAnalysisUtil.isRHS((Graph)node.getGraph())) {
            mappings = aUnit.getRhsMappings();
        } else {
            return null;
        }
        for (Mapping m : mappings) {
            if (m.getImage() != node) continue;
            return m;
        }
        return null;
    }
}

