/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.menuContributors;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.provider.WrapperItemProvider;
import org.eclipse.emf.henshin.editor.commands.CreateMappingCommand;
import org.eclipse.emf.henshin.editor.commands.CreateParameterMappingCommand;
import org.eclipse.emf.henshin.editor.commands.MenuContributor;
import org.eclipse.emf.henshin.editor.commands.QuantUtil;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;

public class CreateMappingCommandMenuContributor
extends MenuContributor {
    public static MenuContributor INSTANCE = new CreateMappingCommandMenuContributor();
    private static final String COMMAND_LABEL = "CreateMapping";

    @Override
    public void contributeActions(IMenuManager menuManager, List<?> selection) {
        if (selection.size() != 2) {
            return;
        }
        Object source = selection.get(0);
        Object target = selection.get(1);
        while (source instanceof WrapperItemProvider) {
            source = ((WrapperItemProvider)source).getValue();
        }
        while (target instanceof WrapperItemProvider) {
            target = ((WrapperItemProvider)target).getValue();
        }
        boolean bNodeMapping = QuantUtil.allInstancesOf(Node.class, source, target);
        boolean bParameterMapping = QuantUtil.allInstancesOf(Parameter.class, source, target);
        if (bNodeMapping) {
            Node sourceNode = (Node)source;
            Node targetNode = (Node)target;
            if (QuantUtil.anyNull(sourceNode.getGraph(), targetNode.getGraph()) || QuantUtil.allIdentical(sourceNode.getGraph(), targetNode.getGraph())) {
                return;
            }
            CreateMappingCommand cmd = new CreateMappingCommand(sourceNode, targetNode);
            if (cmd.canExecute()) {
                menuManager.add(this.createAction(this.getLabel(COMMAND_LABEL), (Command)cmd));
            }
            if ((cmd = new CreateMappingCommand(targetNode, sourceNode)).canExecute()) {
                menuManager.add(this.createAction(this.getLabel(COMMAND_LABEL), (Command)cmd));
            }
        } else if (bParameterMapping) {
            IAction action;
            Parameter sourceParameter = (Parameter)source;
            Parameter targetParameter = (Parameter)target;
            TransformationUnit sourceUnit = sourceParameter.getUnit();
            TransformationUnit targetUnit = targetParameter.getUnit();
            if (!sourceUnit.getSubUnits(false).contains((Object)targetUnit) && !targetUnit.getSubUnits(false).contains((Object)sourceUnit)) {
                return;
            }
            String srcP = String.valueOf(sourceUnit.getName()) + "." + sourceParameter.getName();
            String trgP = String.valueOf(targetUnit.getName()) + "." + targetParameter.getName();
            String labelST = String.valueOf(this.getLabel(COMMAND_LABEL)) + "[" + srcP + " -> " + trgP + "]";
            String labelTS = String.valueOf(this.getLabel(COMMAND_LABEL)) + "[" + srcP + " <- " + trgP + "]";
            CreateParameterMappingCommand cmd = new CreateParameterMappingCommand(sourceParameter, targetParameter);
            if (cmd.canExecute()) {
                action = this.createAction(labelST, (Command)cmd);
                action.setEnabled(cmd.isEnabled());
                menuManager.add(action);
            }
            if ((cmd = new CreateParameterMappingCommand(targetParameter, sourceParameter)).canExecute()) {
                action = this.createAction(labelTS, (Command)cmd);
                action.setEnabled(cmd.isEnabled());
                menuManager.add(action);
            }
        }
    }
}

