/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.testframework;

import org.eclipse.emf.henshin.interpreter.EmfEngine;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.interfaces.InterpreterEngine;
import org.eclipse.emf.henshin.matching.EmfGraph;
import org.eclipse.emf.henshin.model.Rule;

public class Rules {
    public static void assertRuleHasMatch(Rule r, EmfEngine engine) throws AssertionError {
        RuleApplication ra = new RuleApplication((InterpreterEngine)engine, r);
        Rules.assertRuleHasMatch(ra);
    }

    public static void assertRuleHasMatch(Rule r, EmfGraph graph) throws AssertionError {
        RuleApplication ra = new RuleApplication((InterpreterEngine)new EmfEngine(graph), r);
        Rules.assertRuleHasMatch(ra);
    }

    public static void assertRuleHasMatch(RuleApplication ra) throws AssertionError {
        if (ra.findAllMatches().size() == 0) {
            throw new AssertionError((Object)("expected: Rule " + ra.getRule().getName() + " has matches, but has none"));
        }
    }

    public static void assertRuleHasNoMatch(Rule r, EmfEngine engine) throws AssertionError {
        RuleApplication ra = new RuleApplication((InterpreterEngine)engine, r);
        Rules.assertRuleHasNoMatch(ra);
    }

    public static void assertRuleHasNoMatch(Rule r, EmfGraph graph) throws AssertionError {
        RuleApplication ra = new RuleApplication((InterpreterEngine)new EmfEngine(graph), r);
        Rules.assertRuleHasNoMatch(ra);
    }

    public static void assertRuleHasNoMatch(RuleApplication ra) throws AssertionError {
        if (ra.findAllMatches().size() != 0) {
            throw new AssertionError((Object)("expected: Rule " + ra.getRule().getName() + " has no matches, but has " + ra.findAllMatches().size()));
        }
    }

    public static void assertRuleHasNMatches(Rule r, EmfEngine engine, int n) throws AssertionError {
        RuleApplication ra = new RuleApplication((InterpreterEngine)engine, r);
        Rules.assertRuleHasNMatches(ra, n);
    }

    public static void assertRuleHasNMatches(Rule r, EmfGraph graph, int n) throws AssertionError {
        RuleApplication ra = new RuleApplication((InterpreterEngine)new EmfEngine(graph), r);
        Rules.assertRuleHasNMatches(ra, n);
    }

    public static void assertRuleHasNMatches(RuleApplication ra, int n) throws AssertionError {
        if (ra.findAllMatches().size() != n) {
            throw new AssertionError((Object)("expected: Rule " + ra.getRule().getName() + " has " + n + " matches, but has " + ra.findAllMatches().size()));
        }
    }

    public static void assertRuleCanBeAppliedMultipleTimes(Rule r, EmfEngine engine) throws AssertionError {
        RuleApplication ra = new RuleApplication((InterpreterEngine)engine, r);
        Rules.assertRuleCanBeAppliedMultipleTimes(ra);
    }

    public static void assertRuleCanBeAppliedMultipleTimes(Rule r, EmfGraph graph) throws AssertionError {
        RuleApplication ra = new RuleApplication((InterpreterEngine)new EmfEngine(graph), r);
        Rules.assertRuleCanBeAppliedMultipleTimes(ra);
    }

    public static void assertRuleCanBeAppliedMultipleTimes(RuleApplication ra) throws AssertionError {
        Rule raRule = ra.getRule();
        ra.apply();
        RuleApplication ra2 = new RuleApplication(ra.getInterpreterEngine(), raRule);
        if (ra2.findAllMatches().size() == 0) {
            throw new AssertionError((Object)("expected: Rule " + ra.getRule().getName() + " can be applied multiple times."));
        }
    }

    public static void assertRuleCanBeAppliedNTimes(Rule r, EmfEngine engine, int n) throws AssertionError, Exception {
        RuleApplication ra = new RuleApplication((InterpreterEngine)engine, r);
        Rules.assertRuleCanBeAppliedNTimes(ra, n);
    }

    public static void assertRuleCanBeAppliedNTimes(Rule r, EmfGraph graph, int n) throws AssertionError, Exception {
        RuleApplication ra = new RuleApplication((InterpreterEngine)new EmfEngine(graph), r);
        Rules.assertRuleCanBeAppliedNTimes(ra, n);
    }

    public static void assertRuleCanBeAppliedNTimes(RuleApplication ra, int n) throws AssertionError, Exception {
        if (n < 0) {
            throw new Exception("n needs to be positive.");
        }
        Rule raRule = ra.getRule();
        ra.apply();
        int i = 0;
        while (i < n - 1) {
            RuleApplication ra2 = new RuleApplication(ra.getInterpreterEngine(), raRule);
            ra2.apply();
            ++i;
        }
        RuleApplication ra2 = new RuleApplication(ra.getInterpreterEngine(), raRule);
        if (ra2.findAllMatches().size() == 0) {
            throw new AssertionError((Object)("expected: Rule " + ra.getRule().getName() + " can be applied at least " + n + " times"));
        }
    }

    public static void assertRuleExecutedByUnitApplication(UnitApplication ua, Rule r) throws AssertionError {
        for (RuleApplication ra : ua.getAppliedRules()) {
            if (!ra.getRule().equals(r)) continue;
            return;
        }
        throw new AssertionError((Object)("expected: Rule " + r.getName() + " executed by UnitApplication " + ua.getTransformationUnit().getName() + ", but wasn't."));
    }

    public static void assertRuleExecutedByUnitApplicationNTimes(UnitApplication ua, Rule r, int n) throws AssertionError {
        int ctr = n;
        for (RuleApplication ra : ua.getAppliedRules()) {
            if (!ra.getRule().equals(r)) continue;
            --ctr;
        }
        if (ctr == 0) {
            return;
        }
        throw new AssertionError((Object)("expected: Rule " + r.getName() + " executed " + n + " times by UnitApplication, but was executed " + (n - ctr) + " times."));
    }

    public static void assertRuleCanBeApplied(Rule r, EmfEngine engine) throws AssertionError {
        Rules.assertRuleCanBeApplied(new RuleApplication((InterpreterEngine)engine, r));
    }

    public static void assertRuleCanBeApplied(Rule r, EmfGraph graph) throws AssertionError {
        Rules.assertRuleCanBeApplied(new RuleApplication((InterpreterEngine)new EmfEngine(graph), r));
    }

    public static void assertRuleCanBeApplied(RuleApplication ra) throws AssertionError {
        boolean result = ra.apply();
        if (!result) {
            throw new AssertionError((Object)("expected: Rule " + ra.getRule().getName() + " can be applied."));
        }
    }
}

