/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.actions.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.actions.Action;
import org.eclipse.emf.henshin.model.actions.ActionType;
import org.eclipse.emf.henshin.model.actions.internal.ActionHelper;
import org.eclipse.emf.henshin.model.util.HenshinACUtil;
import org.eclipse.emf.henshin.model.util.HenshinMappingUtil;

class ActionElementFinder {
    ActionElementFinder() {
    }

    static <E extends GraphElement> List<E> getRuleElementCandidates(Rule kernel, Action action, EReference containment) {
        ArrayList candidates = new ArrayList();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (action == null || !action.isAmalgamated()) {
            rules.add(kernel);
        }
        if (action == null || action.isAmalgamated()) {
            rules.addAll((Collection<Rule>)kernel.getMultiRules());
        }
        if (action == null || action.getType() == ActionType.DELETE || action.getType() == ActionType.PRESERVE) {
            for (Rule rule : rules) {
                candidates.addAll((List)rule.getLhs().eGet((EStructuralFeature)containment));
            }
        }
        if (action == null || action.getType() == ActionType.CREATE) {
            for (Rule rule : rules) {
                candidates.addAll((List)rule.getRhs().eGet((EStructuralFeature)containment));
            }
        }
        if (action == null || action.getType() == ActionType.REQUIRE) {
            for (NestedCondition pac : HenshinACUtil.getAllACs(kernel, true)) {
                candidates.addAll((List)pac.getConclusion().eGet((EStructuralFeature)containment));
            }
        }
        if (action == null || action.getType() == ActionType.FORBID) {
            for (NestedCondition nac : HenshinACUtil.getAllACs(kernel, false)) {
                candidates.addAll((List)nac.getConclusion().eGet((EStructuralFeature)containment));
            }
        }
        return candidates;
    }

    static <E extends GraphElement> E getActionElement(E element, ActionHelper<E, Rule> helper) {
        if (helper.getAction(element) != null) {
            return element;
        }
        EObject container = element.getGraph().eContainer();
        if (container instanceof Rule) {
            E originInKernel;
            Rule rule = (Rule)container;
            E origin = HenshinMappingUtil.getOrigin(element, rule.getMappings());
            if (origin == null) {
                origin = element;
            }
            if ((originInKernel = rule.getOriginInKernelRule(origin)) != null) {
                return originInKernel;
            }
            return origin;
        }
        if (container instanceof NestedCondition) {
            EList<Mapping> mappings = ((NestedCondition)container).getMappings();
            return HenshinMappingUtil.getOrigin(element, mappings);
        }
        throw new RuntimeException("Graph neither contained in a Rule nor in a NestedCondition");
    }
}

