/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.util.HenshinACUtil;
import org.eclipse.emf.henshin.model.util.HenshinMultiRuleUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;

public class NodeDeleteCommand
extends AbstractTransactionalCommand {
    private Node node;

    public NodeDeleteCommand(TransactionalEditingDomain domain, Node node) {
        super(domain, "Delete Node", null);
        this.node = node;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.node.getGraph() == null) {
            return CommandResult.newOKCommandResult();
        }
        Rule rule = this.node.getGraph().getContainerRule();
        rule.removeNode(this.node, true);
        HenshinACUtil.removeTrivialACs((Rule)rule);
        HenshinMultiRuleUtil.removeTrivialMultiRules((Rule)rule);
        return CommandResult.newOKCommandResult();
    }
}

