/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.part;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.diagram.edit.helpers.UnitEditHelper;
import org.eclipse.emf.henshin.diagram.edit.parts.SymbolType;
import org.eclipse.emf.henshin.diagram.part.HenshinSymbolUpdater;
import org.eclipse.emf.henshin.diagram.part.HenshinVisualIDRegistry;
import org.eclipse.emf.henshin.diagram.providers.HenshinViewProvider;
import org.eclipse.emf.henshin.model.ConditionalUnit;
import org.eclipse.emf.henshin.model.IndependentUnit;
import org.eclipse.emf.henshin.model.LoopUnit;
import org.eclipse.emf.henshin.model.PriorityUnit;
import org.eclipse.emf.henshin.model.SequentialUnit;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.View;

public class HenshinLinkUpdater {
    private PreferencesHint prefHint;
    private boolean persisted;
    private HenshinViewProvider provider;
    private HenshinSymbolUpdater symbolHelper;
    private static final String LINK_VISUAL_ID = HenshinVisualIDRegistry.getType(4002);
    private static final Edge DUMMY_EDGE = NotationFactory.eINSTANCE.createEdge();

    public HenshinLinkUpdater(PreferencesHint prefHint, boolean persisted) {
        this.prefHint = prefHint;
        this.persisted = persisted;
        this.provider = new HenshinViewProvider();
        this.symbolHelper = new HenshinSymbolUpdater(prefHint, persisted);
    }

    public void update(View unitView) {
        View compartment = UnitEditHelper.getUnitCompartment(unitView);
        TransformationUnit unit = (TransformationUnit)((View)compartment.eContainer()).getElement();
        View begin = this.getSymbol(unit, compartment, SymbolType.UNIT_BEGIN);
        View end = this.getSymbol(unit, compartment, SymbolType.UNIT_END);
        List<View> invocations = UnitEditHelper.getInvocationViews(unitView, false);
        HashSet<Edge> knownLinks = new HashSet<Edge>();
        HashSet<View> nodes = new HashSet<View>();
        for (View node : invocations) {
            if (node == null) continue;
            nodes.add(node);
        }
        if (begin != null) {
            nodes.add(begin);
        }
        if (end != null) {
            nodes.add(end);
        }
        if (unit instanceof SequentialUnit || unit instanceof PriorityUnit) {
            if (invocations.isEmpty()) {
                knownLinks.add(this.updateLink(unit, begin, end));
            } else {
                int count = invocations.size();
                knownLinks.add(this.updateLink(unit, begin, invocations.get(0)));
                knownLinks.add(this.updateLink(unit, invocations.get(count - 1), end));
                int i = 1;
                while (i < count) {
                    knownLinks.add(this.updateLink(unit, invocations.get(i - 1), invocations.get(i)));
                    ++i;
                }
            }
        }
        if (unit instanceof IndependentUnit) {
            int size = invocations.size();
            if (size == 0) {
                knownLinks.add(this.updateLink(unit, begin, end));
            } else if (size == 1) {
                knownLinks.add(this.updateLink(unit, begin, invocations.get(0)));
                knownLinks.add(this.updateLink(unit, invocations.get(0), end));
            } else {
                View choice = this.getSymbol(unit, compartment, SymbolType.INDEPENDENT_CHOICE);
                knownLinks.add(this.updateLink(unit, begin, choice));
                for (View invocation : invocations) {
                    knownLinks.add(this.updateLink(unit, choice, invocation));
                    knownLinks.add(this.updateLink(unit, invocation, end));
                }
                nodes.add(choice);
            }
        }
        if (unit instanceof ConditionalUnit) {
            View ifView = UnitEditHelper.getInvocationView(unitView, UnitEditHelper.InvocationViewKey.IF);
            View thenView = UnitEditHelper.getInvocationView(unitView, UnitEditHelper.InvocationViewKey.THEN);
            View elseView = UnitEditHelper.getInvocationView(unitView, UnitEditHelper.InvocationViewKey.ELSE);
            if (ifView != null) {
                knownLinks.add(this.updateLink(unit, begin, ifView));
                if (thenView != null) {
                    knownLinks.add(this.updateLink(unit, ifView, thenView));
                    knownLinks.add(this.updateLink(unit, thenView, end));
                }
                if (elseView != null) {
                    knownLinks.add(this.updateLink(unit, ifView, elseView));
                    knownLinks.add(this.updateLink(unit, elseView, end));
                }
            }
        }
        if (unit instanceof LoopUnit) {
            View subUnitView = UnitEditHelper.getInvocationView(unitView, UnitEditHelper.InvocationViewKey.LOOP);
            if (subUnitView != null) {
                knownLinks.add(this.updateLink(unit, begin, subUnitView));
                knownLinks.add(this.updateLink(unit, subUnitView, end));
                knownLinks.add(this.updateLink(unit, subUnitView, subUnitView));
            } else {
                knownLinks.add(this.updateLink(unit, begin, end));
            }
        }
        this.deleteUnknownLinks(unitView.getDiagram(), knownLinks, nodes);
    }

    /*
     * Unable to fully structure code
     */
    private Edge updateLink(TransformationUnit unit, View source, View target) {
        block1: {
            if (source == null || target == null) break block1;
            links = this.getLinks(source, target);
            if (!links.isEmpty()) ** GOTO lbl12
            link = this.provider.createLink_4002((View)source.getDiagram(), -1, this.persisted, this.prefHint);
            routingStyle = (RoutingStyle)link.getStyle(NotationPackage.eINSTANCE.getRoutingStyle());
            routingStyle.setRouting(Routing.RECTILINEAR_LITERAL);
            link.setElement((EObject)unit);
            link.setSource(source);
            link.setTarget(target);
            return link;
lbl-1000:
            // 1 sources

            {
                ViewUtil.destroy((View)((View)links.remove(links.size() - 1)));
lbl12:
                // 2 sources

                ** while (links.size() > 1)
            }
lbl13:
            // 1 sources

            return links.get(0);
        }
        return HenshinLinkUpdater.DUMMY_EDGE;
    }

    private void deleteUnknownLinks(Diagram diagram, Collection<Edge> knownLinks, Collection<View> nodes) {
        Object[] objectArray = diagram.getEdges().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object link = objectArray[n2];
            if (!knownLinks.contains(link) && nodes.contains(((Edge)link).getSource()) && nodes.contains(((Edge)link).getTarget())) {
                ViewUtil.destroy((View)((Edge)link));
            }
            ++n2;
        }
    }

    private List<Edge> getLinks(View source, View target) {
        ArrayList<Edge> links = new ArrayList<Edge>();
        if (source != null && target != null) {
            for (Object obj : source.getDiagram().getEdges()) {
                Edge edge = (Edge)obj;
                if (!LINK_VISUAL_ID.equals(edge.getType()) || source != edge.getSource() || target != edge.getTarget()) continue;
                links.add(edge);
            }
        }
        return links;
    }

    private View getSymbol(TransformationUnit unit, View compartment, SymbolType type) {
        if (unit == null || compartment == null || type == null) {
            return null;
        }
        List<View> symbols = this.symbolHelper.getSymbols(unit, compartment, type);
        return symbols.isEmpty() ? null : symbols.get(0);
    }

    public static boolean isIfLink(TransformationUnit unit, View link) {
        View target;
        if (unit instanceof ConditionalUnit && link instanceof Edge && (target = ((Edge)link).getTarget()) != null) {
            View unitView = (View)target.eContainer().eContainer();
            View ifView = UnitEditHelper.getInvocationView(unitView, UnitEditHelper.InvocationViewKey.IF);
            return target == ifView;
        }
        return false;
    }

    public static boolean isThenLink(TransformationUnit unit, View link) {
        if (unit instanceof ConditionalUnit && link instanceof Edge) {
            View source = ((Edge)link).getSource();
            View target = ((Edge)link).getTarget();
            if (source != null && target != null) {
                View unitView = (View)source.eContainer().eContainer();
                View ifView = UnitEditHelper.getInvocationView(unitView, UnitEditHelper.InvocationViewKey.IF);
                View thenView = UnitEditHelper.getInvocationView(unitView, UnitEditHelper.InvocationViewKey.THEN);
                return source == ifView && target == thenView;
            }
        }
        return false;
    }

    public static boolean isElseLink(TransformationUnit unit, View link) {
        if (unit instanceof ConditionalUnit && link instanceof Edge) {
            View source = ((Edge)link).getSource();
            View target = ((Edge)link).getTarget();
            if (source != null && target != null) {
                View unitView = (View)source.eContainer().eContainer();
                View ifView = UnitEditHelper.getInvocationView(unitView, UnitEditHelper.InvocationViewKey.IF);
                View elseView = UnitEditHelper.getInvocationView(unitView, UnitEditHelper.InvocationViewKey.ELSE);
                return source == ifView && target == elseView;
            }
        }
        return false;
    }
}

