/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.impl.StateSpaceManagerImpl;

public class MultiThreadedStateSpaceManager
extends StateSpaceManagerImpl {
    private int numWorkers;
    private ExecutorService executor;
    private Future<StateSpaceException>[] futures;

    public MultiThreadedStateSpaceManager(StateSpace stateSpace, int numThreads) {
        super(stateSpace);
        this.numWorkers = Math.max(numThreads, 1);
        this.executor = Executors.newFixedThreadPool(this.numWorkers);
        this.futures = new Future[this.numWorkers];
    }

    public MultiThreadedStateSpaceManager(StateSpace stateSpace) {
        this(stateSpace, Runtime.getRuntime().availableProcessors());
    }

    @Override
    public synchronized List<State> exploreStates(List<State> states, boolean generateLocations) throws StateSpaceException {
        Vector<State> queue = new Vector<State>(states);
        Vector<State> result = new Vector<State>();
        try {
            int i = 0;
            while (i < this.numWorkers) {
                this.futures[i] = this.executor.submit(new ExplorationWorker(queue, result, generateLocations));
                ++i;
            }
            i = 0;
            while (i < this.numWorkers) {
                if (this.futures[i].get() != null) {
                    throw this.futures[i].get();
                }
                ++i;
            }
        }
        catch (Throwable t) {
            throw this.wrapException(t);
        }
        return result;
    }

    private StateSpaceException wrapException(Throwable t) {
        return t instanceof StateSpaceException ? (StateSpaceException)t : new StateSpaceException(t);
    }

    private class ExplorationWorker
    implements Callable<StateSpaceException> {
        private List<State> states;
        private List<State> result;
        private boolean generateLocations;

        ExplorationWorker(List<State> states, List<State> result, boolean generateLocations) {
            this.states = states;
            this.result = result;
            this.generateLocations = generateLocations;
        }

        @Override
        public StateSpaceException call() {
            while (true) {
                State next;
                try {
                    next = this.states.remove(0);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return null;
                }
                try {
                    this.result.addAll(MultiThreadedStateSpaceManager.this.exploreState(next, this.generateLocations));
                }
                catch (Throwable t) {
                    return MultiThreadedStateSpaceManager.this.wrapException(t);
                }
            }
        }
    }
}

