/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.testframework;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.resource.StateSpaceResourceSet;
import org.eclipse.emf.henshin.statespace.util.StateSpaceExplorationHelper;

public abstract class StateSpaceTest {
    protected StateSpace loadStateSpace(File file) {
        StateSpaceResourceSet resourceSet = new StateSpaceResourceSet();
        return resourceSet.getStateSpace(file.getAbsolutePath());
    }

    protected List<File> findStateSpaceFiles(File path) {
        ArrayList<File> files = new ArrayList<File>();
        this.addStateSpaceFiles(path, files);
        Collections.sort(files);
        return files;
    }

    private void addStateSpaceFiles(File file, List<File> stateSpaceFiles) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.addStateSpaceFiles(child, stateSpaceFiles);
                ++n2;
            }
        } else if (file.getName().endsWith(".statespace")) {
            stateSpaceFiles.add(file);
        }
    }

    protected void doFullExploration(StateSpaceManager manager, boolean printProgress) {
        StateSpaceExplorationHelper helper = new StateSpaceExplorationHelper(manager);
        helper.setStepDuration(5000);
        long start = System.currentTimeMillis();
        try {
            while (helper.doExplorationStep()) {
                if (!printProgress) continue;
                System.out.print(".");
            }
        }
        catch (StateSpaceException e) {
            throw new RuntimeException(e);
        }
        if (printProgress) {
            long duration = (System.currentTimeMillis() - start) / 1000L;
            System.out.println(" done in " + duration + " seconds");
        }
    }

    protected void doStateSpaceReset(StateSpaceManager manager) {
        try {
            manager.resetStateSpace();
        }
        catch (StateSpaceException e) {
            throw new RuntimeException(e);
        }
    }
}

