/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.testframework;

import org.eclipse.emf.henshin.interpreter.EmfEngine;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.interfaces.InterpreterEngine;
import org.eclipse.emf.henshin.matching.EmfGraph;
import org.eclipse.emf.henshin.model.TransformationUnit;

public class TransformationUnits {
    public static void assertTransformationUnitCanBeExecutedMultipleTimes(TransformationUnit tu, EmfGraph graph) throws AssertionError {
        TransformationUnits.assertTransformationUnitCanBeExecutedMultipleTimes(tu, new EmfEngine(graph));
    }

    public static void assertTransformationUnitCanBeExecutedMultipleTimes(TransformationUnit tu, EmfEngine engine) throws AssertionError {
        TransformationUnits.assertUnitApplicationCanBeExecutedMultipleTimes(new UnitApplication((InterpreterEngine)engine, tu));
    }

    public static void assertUnitApplicationCanBeExecutedMultipleTimes(UnitApplication ua) throws AssertionError {
        TransformationUnit tu = ua.getTransformationUnit();
        EmfEngine engine = (EmfEngine)ua.getInterpreterEngine();
        ua.execute();
        if (ua.getAppliedRules().size() > 0) {
            UnitApplication ua2 = new UnitApplication((InterpreterEngine)engine, tu);
            ua2.execute();
            if (ua2.getAppliedRules().size() > 0) {
                return;
            }
            throw new AssertionError((Object)"expected: UnitApplication can be executed multiple times, but could just be executed once.");
        }
        throw new AssertionError((Object)"expected: UnitApplication can be executed multiple times, but couldn't even be executed once.");
    }

    public static void assertTransformationUnitCanBeExecutedNTimes(TransformationUnit tu, EmfGraph graph, int n) throws AssertionError {
        TransformationUnits.assertTransformationUnitCanBeExecutedNTimes(tu, new EmfEngine(graph), n);
    }

    public static void assertTransformationUnitCanBeExecutedNTimes(TransformationUnit tu, EmfEngine engine, int n) throws AssertionError {
        TransformationUnits.assertUnitApplicationCanBeExecutedNTimes(new UnitApplication((InterpreterEngine)engine, tu), n);
    }

    public static void assertUnitApplicationCanBeExecutedNTimes(UnitApplication ua, int n) throws AssertionError {
        TransformationUnit tu = ua.getTransformationUnit();
        EmfEngine engine = (EmfEngine)ua.getInterpreterEngine();
        int i = 0;
        while (i < n) {
            UnitApplication ua2 = new UnitApplication((InterpreterEngine)engine, tu);
            ua2.execute();
            if (ua2.getAppliedRules().size() <= 0) {
                throw new AssertionError((Object)("expected: UnitApplication can be executed at least " + n + " times, but could only be executed " + i + " times"));
            }
            ++i;
        }
    }

    public static void assertTuCanBeExecuted(UnitApplication ua) throws AssertionError {
        if (!ua.execute()) {
            throw new AssertionError((Object)"expected: UnitApplication can be executed.");
        }
    }

    public static void assertTuCanNotBeExecuted(UnitApplication ua) throws AssertionError {
        if (ua.execute()) {
            throw new AssertionError((Object)"expected: UnitApplication can not be executed.");
        }
    }
}

