/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.InterpreterFactory;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.EqualityHelper;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.Path;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceFactory;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.hashcodes.StateSpaceHashCodeUtil;
import org.eclipse.emf.henshin.statespace.impl.ModelPostProcessor;
import org.eclipse.emf.henshin.statespace.util.ObjectKeyHelper;
import org.eclipse.emf.henshin.statespace.util.ParameterUtil;

public class StateExplorer {
    private final StateSpaceManager manager;
    private final StateSpace stateSpace;
    private final EqualityHelper equalityHelper;
    private Engine engine;
    private final List<Transition> result;
    private final boolean useObjectKeys;
    private final Rule[] rules;
    private final Map<Rule, List<Node>> ruleParameters;
    private final RuleApplication application;
    private final EList<EClass> identityTypes;
    private final ModelPostProcessor postProcessor;
    private final boolean collectMissingRoots;

    public StateExplorer(StateSpaceManager manager) {
        String collect;
        this.manager = manager;
        this.stateSpace = manager.getStateSpace();
        this.equalityHelper = this.stateSpace.getEqualityHelper();
        this.result = new ArrayList<Transition>();
        this.identityTypes = this.equalityHelper.getIdentityTypes();
        this.useObjectKeys = !this.identityTypes.isEmpty();
        this.rules = (Rule[])this.stateSpace.getRules().toArray((Object[])new Rule[0]);
        this.ruleParameters = new HashMap<Rule, List<Node>>();
        if (this.useObjectKeys) {
            Rule[] ruleArray = this.rules;
            int n = this.rules.length;
            int n2 = 0;
            while (n2 < n) {
                Rule rule = ruleArray[n2];
                try {
                    this.ruleParameters.put(rule, ParameterUtil.getParameters(this.stateSpace, rule));
                }
                catch (StateSpaceException e) {
                    throw new RuntimeException(e);
                }
                ++n2;
            }
        }
        this.collectMissingRoots = (collect = (String)this.stateSpace.getProperties().get((Object)"collectMissingRoots")) != null && ("true".equalsIgnoreCase(collect) || "yes".equalsIgnoreCase(collect));
        this.engine = InterpreterFactory.INSTANCE.createEngine();
        this.engine.getOptions().put("DETERMINISTIC", Boolean.TRUE);
        this.application = InterpreterFactory.INSTANCE.createRuleApplication(this.engine);
        this.postProcessor = new ModelPostProcessor(this.stateSpace);
    }

    public List<Transition> doExplore(State state) throws StateSpaceException {
        this.result.clear();
        Model model = this.manager.getModel(state);
        EGraph graph = model.getEGraph();
        int i = 0;
        while (i < this.rules.length) {
            List<Node> parameters = this.ruleParameters.get(this.rules[i]);
            int matchIndex = 0;
            for (Match match : this.engine.findMatches(this.rules[i], graph, null)) {
                Model transformed = model.getCopy(match);
                this.application.setRule(this.rules[i]);
                this.application.setEGraph(transformed.getEGraph());
                this.application.setCompleteMatch(match);
                if (!this.application.execute(null)) {
                    throw new StateSpaceException("Error applying rule \"" + this.rules[i].getName() + "\" to found match in state " + state.getIndex());
                }
                this.postProcessor.process(transformed);
                if (this.collectMissingRoots) {
                    transformed.collectMissingRootObjects();
                }
                State newState = StateSpaceFactory.eINSTANCE.createState();
                newState.setModel(transformed);
                if (this.useObjectKeys) {
                    transformed.updateObjectKeys(this.identityTypes);
                    int[] objectKeys = transformed.getObjectKeys();
                    newState.setObjectKeys(objectKeys);
                    newState.setObjectCount(objectKeys.length);
                }
                int newHashCode = this.equalityHelper.hashCode(transformed);
                newState.setHashCode(newHashCode);
                newState.setDerivedFrom(state.getIndex());
                Transition newTransition = StateSpaceFactory.eINSTANCE.createTransition();
                newTransition.setRule(this.rules[i]);
                newTransition.setMatch(matchIndex);
                newTransition.setTarget(newState);
                if (this.useObjectKeys) {
                    int[] params = new int[parameters.size()];
                    int p = 0;
                    while (p < params.length) {
                        Node node = parameters.get(p);
                        EObject matched = match.getNodeTarget(node);
                        if (matched == null) {
                            matched = this.application.getResultMatch().getNodeTarget(node);
                        }
                        int objectKey = (Integer)transformed.getObjectKeysMap().get((Object)matched);
                        params[p] = ObjectKeyHelper.createObjectKey(matched.eClass(), objectKey, this.identityTypes);
                        ++p;
                    }
                    newTransition.setParameterKeys(params);
                    newTransition.setParameterCount(params.length);
                }
                this.result.add(newTransition);
                ++matchIndex;
            }
            ++i;
        }
        return this.result;
    }

    public Model deriveModel(Path trace, Model model) throws StateSpaceException {
        model = model.getCopy(null);
        EGraph graph = model.getEGraph();
        this.application.setEGraph(graph);
        for (Transition transition : trace) {
            this.application.setRule(transition.getRule());
            int targetMatch = transition.getMatch();
            int currentMatch = 0;
            Match match = null;
            for (Match foundMatch : this.engine.findMatches(transition.getRule(), graph, null)) {
                if (currentMatch++ != targetMatch) continue;
                match = foundMatch;
            }
            if (match == null) {
                throw new StateSpaceException("Illegal transition in state " + transition.getSource());
            }
            this.application.setCompleteMatch(match);
            if (!this.application.execute(null)) {
                throw new StateSpaceException("Error deriving model");
            }
            this.postProcessor.process(model);
            if (!this.collectMissingRoots) continue;
            model.collectMissingRootObjects();
        }
        if (this.useObjectKeys) {
            model.setObjectKeys(trace.getTarget().getObjectKeys());
        }
        StateSpaceHashCodeUtil.computeHashCode(model, this.equalityHelper);
        return model;
    }
}

