/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.EqualityHelper;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceFactory;
import org.eclipse.emf.henshin.statespace.StateSpacePackage;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.impl.EqualityHelperImpl;
import org.eclipse.emf.henshin.statespace.impl.StorageImpl;

public class StateSpaceImpl
extends StorageImpl
implements StateSpace {
    protected EList<Rule> rules;
    protected EList<State> states;
    protected EList<State> initialStates;
    protected Set<State> openStates;
    protected static final int STATE_COUNT_EDEFAULT = 0;
    protected static final int TRANSITION_COUNT_EDEFAULT = 0;
    protected int transitionCount = 0;
    protected EqualityHelper equalityHelper;
    protected static final int LAYOUT_ZOOM_LEVEL_EDEFAULT = 0;
    protected static final int LAYOUT_STATE_REPULSION_EDEFAULT = 0;
    protected static final int LAYOUT_TRANSITION_ATTRACTION_EDEFAULT = 0;
    protected static final boolean LAYOUT_HIDE_LABELS_EDEFAULT = false;
    protected static final int MAX_STATE_DISTANCE_EDEFAULT = -1;
    protected EMap<String, String> properties;
    protected static final int[] ALL_PARAMETER_KEYS_EDEFAULT = null;

    protected StateSpaceImpl() {
        this.getProperties().put((Object)"checkLinkOrder", (Object)"false");
        this.getProperties().put((Object)"identityTypes", (Object)"");
        this.getProperties().put((Object)"ignoredAttributes", (Object)"");
        this.setEqualityHelper(StateSpaceFactory.eINSTANCE.createEqualityHelper());
        this.openStates = new LinkedHashSet<State>();
    }

    @Override
    public Set<State> getOpenStates() {
        return this.openStates;
    }

    @Override
    public int getStateCount() {
        return this.getStates().size();
    }

    @Override
    public boolean removeState(State state) {
        if (this.getStates().remove((Object)state)) {
            for (Transition transition : state.getIncoming()) {
                State source = transition.getSource();
                if (source != null) {
                    source.setOpen(true);
                    if (!this.getOpenStates().contains(source)) {
                        this.getOpenStates().add(source);
                    }
                }
                transition.setSource(null);
            }
            for (Transition transition : state.getOutgoing()) {
                transition.setTarget(null);
            }
            int index = 0;
            for (State current : this.getStates()) {
                current.setIndex(index++);
            }
            return true;
        }
        return false;
    }

    @Override
    public void updateEqualityHelper() {
        if (this.equalityHelper == null) {
            this.equalityHelper = new EqualityHelperImpl();
        }
        this.equalityHelper.setStateSpace(this);
    }

    @Override
    public int incTransitionCount() {
        return this.transitionCount++;
    }

    @Override
    public int[] getAllParameterKeys() {
        int i;
        LinkedHashSet<Integer> objectKeys = new LinkedHashSet<Integer>();
        for (State state : this.getStates()) {
            for (Transition transition : state.getOutgoing()) {
                int paramCount = transition.getParameterCount();
                int[] params = transition.getParameterKeys();
                i = 0;
                while (i < paramCount) {
                    objectKeys.add(params[i]);
                    ++i;
                }
            }
        }
        int[] result = new int[objectKeys.size()];
        i = 0;
        for (Integer key : objectKeys) {
            result[i++] = key;
        }
        return result;
    }

    private int getPercent(int index, int def) {
        int p = this.getData(index);
        return p == 0 ? def : Math.min(100, Math.max(p, 1));
    }

    private void setPercent(int index, int p) {
        p = Math.min(100, Math.max(p, 1));
        if (this.getData(index) != p) {
            this.setData(index, p);
        }
    }

    @Override
    public int getLayoutZoomLevel() {
        return this.getPercent(0, 100);
    }

    @Override
    public void setLayoutZoomLevel(int zoomLevel) {
        this.setPercent(0, zoomLevel);
    }

    @Override
    public int getLayoutStateRepulsion() {
        return this.getPercent(1, 50);
    }

    @Override
    public void setLayoutStateRepulsion(int repulsion) {
        this.setPercent(1, repulsion);
    }

    @Override
    public int getLayoutTransitionAttraction() {
        return this.getPercent(2, 50);
    }

    @Override
    public void setLayoutTransitionAttraction(int attraction) {
        this.setPercent(2, attraction);
    }

    @Override
    public int getMaxStateDistance() {
        int maxDistance = this.getData(3);
        return maxDistance > 0 ? maxDistance : -1;
    }

    @Override
    public void setMaxStateDistance(int maxStateDistance) {
        this.setData(3, maxStateDistance);
    }

    @Override
    public boolean isLayoutHideLabels() {
        return this.getData(4) != 0;
    }

    @Override
    public void setLayoutHideLabels(boolean hideLabels) {
        this.setData(4, hideLabels ? 1 : 0);
    }

    @Override
    protected EClass eStaticClass() {
        return StateSpacePackage.Literals.STATE_SPACE;
    }

    @Override
    public EList<State> getStates() {
        if (this.states == null) {
            this.states = new EObjectContainmentWithInverseEList(State.class, (InternalEObject)this, 2, 4);
        }
        return this.states;
    }

    @Override
    public EList<State> getInitialStates() {
        if (this.initialStates == null) {
            this.initialStates = new EObjectResolvingEList(State.class, (InternalEObject)this, 3);
        }
        return this.initialStates;
    }

    @Override
    public EList<Rule> getRules() {
        if (this.rules == null) {
            this.rules = new EObjectResolvingEList(Rule.class, (InternalEObject)this, 1);
        }
        return this.rules;
    }

    @Override
    public int getTransitionCount() {
        return this.transitionCount;
    }

    @Override
    public void setTransitionCount(int newTransitionCount) {
        int oldTransitionCount = this.transitionCount;
        this.transitionCount = newTransitionCount;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldTransitionCount, this.transitionCount));
        }
    }

    @Override
    public EqualityHelper getEqualityHelper() {
        return this.equalityHelper;
    }

    @Override
    public EMap<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new EcoreEMap(EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY, EStringToStringMapEntryImpl.class, (InternalEObject)this, 13);
        }
        return this.properties;
    }

    public NotificationChain basicSetEqualityHelper(EqualityHelper newEqualityHelper, NotificationChain msgs) {
        EqualityHelper oldEqualityHelper = this.equalityHelper;
        this.equalityHelper = newEqualityHelper;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldEqualityHelper, (Object)newEqualityHelper);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setEqualityHelper(EqualityHelper newEqualityHelper) {
        if (newEqualityHelper != this.equalityHelper) {
            NotificationChain msgs = null;
            if (this.equalityHelper != null) {
                msgs = ((InternalEObject)this.equalityHelper).eInverseRemove((InternalEObject)this, -8, null, msgs);
            }
            if (newEqualityHelper != null) {
                msgs = ((InternalEObject)newEqualityHelper).eInverseAdd((InternalEObject)this, -8, null, msgs);
            }
            if ((msgs = this.basicSetEqualityHelper(newEqualityHelper, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)newEqualityHelper, (Object)newEqualityHelper));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getStates()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getStates()).basicRemove((Object)otherEnd, msgs);
            }
            case 7: {
                return this.basicSetEqualityHelper(null, msgs);
            }
            case 13: {
                return ((InternalEList)this.getProperties()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getRules();
            }
            case 2: {
                return this.getStates();
            }
            case 3: {
                return this.getInitialStates();
            }
            case 4: {
                return this.getOpenStates();
            }
            case 5: {
                return this.getStateCount();
            }
            case 6: {
                return this.getTransitionCount();
            }
            case 7: {
                return this.getEqualityHelper();
            }
            case 8: {
                return this.getLayoutZoomLevel();
            }
            case 9: {
                return this.getLayoutStateRepulsion();
            }
            case 10: {
                return this.getLayoutTransitionAttraction();
            }
            case 11: {
                return this.isLayoutHideLabels();
            }
            case 12: {
                return this.getMaxStateDistance();
            }
            case 13: {
                if (coreType) {
                    return this.getProperties();
                }
                return this.getProperties().map();
            }
            case 14: {
                return this.getAllParameterKeys();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getRules().clear();
                this.getRules().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getStates().clear();
                this.getStates().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getInitialStates().clear();
                this.getInitialStates().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getOpenStates().clear();
                this.getOpenStates().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.setTransitionCount((Integer)newValue);
                return;
            }
            case 7: {
                this.setEqualityHelper((EqualityHelper)newValue);
                return;
            }
            case 8: {
                this.setLayoutZoomLevel((Integer)newValue);
                return;
            }
            case 9: {
                this.setLayoutStateRepulsion((Integer)newValue);
                return;
            }
            case 10: {
                this.setLayoutTransitionAttraction((Integer)newValue);
                return;
            }
            case 11: {
                this.setLayoutHideLabels((Boolean)newValue);
                return;
            }
            case 12: {
                this.setMaxStateDistance((Integer)newValue);
                return;
            }
            case 13: {
                ((EStructuralFeature.Setting)this.getProperties()).set(newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getRules().clear();
                return;
            }
            case 2: {
                this.getStates().clear();
                return;
            }
            case 3: {
                this.getInitialStates().clear();
                return;
            }
            case 4: {
                this.getOpenStates().clear();
                return;
            }
            case 6: {
                this.setTransitionCount(0);
                return;
            }
            case 7: {
                this.setEqualityHelper(null);
                return;
            }
            case 8: {
                this.setLayoutZoomLevel(0);
                return;
            }
            case 9: {
                this.setLayoutStateRepulsion(0);
                return;
            }
            case 10: {
                this.setLayoutTransitionAttraction(0);
                return;
            }
            case 11: {
                this.setLayoutHideLabels(false);
                return;
            }
            case 12: {
                this.setMaxStateDistance(-1);
                return;
            }
            case 13: {
                this.getProperties().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.rules != null && !this.rules.isEmpty();
            }
            case 2: {
                return this.states != null && !this.states.isEmpty();
            }
            case 3: {
                return this.initialStates != null && !this.initialStates.isEmpty();
            }
            case 4: {
                return this.openStates != null && !this.openStates.isEmpty();
            }
            case 5: {
                return this.getStateCount() != 0;
            }
            case 6: {
                return this.transitionCount != 0;
            }
            case 7: {
                return this.equalityHelper != null;
            }
            case 8: {
                return this.getLayoutZoomLevel() != 0;
            }
            case 9: {
                return this.getLayoutStateRepulsion() != 0;
            }
            case 10: {
                return this.getLayoutTransitionAttraction() != 0;
            }
            case 11: {
                return this.isLayoutHideLabels();
            }
            case 12: {
                return this.getMaxStateDistance() != -1;
            }
            case 13: {
                return this.properties != null && !this.properties.isEmpty();
            }
            case 14: {
                return ALL_PARAMETER_KEYS_EDEFAULT == null ? this.getAllParameterKeys() != null : !ALL_PARAMETER_KEYS_EDEFAULT.equals(this.getAllParameterKeys());
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (transitionCount: ");
        result.append(this.transitionCount);
        result.append(')');
        return result.toString();
    }
}

