/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.parsers;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.henshin.diagram.edit.helpers.UnitEditHelper;
import org.eclipse.emf.henshin.diagram.parsers.AbstractParser;
import org.eclipse.emf.henshin.model.ConditionalUnit;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.IndependentUnit;
import org.eclipse.emf.henshin.model.IteratedUnit;
import org.eclipse.emf.henshin.model.LoopUnit;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterMapping;
import org.eclipse.emf.henshin.model.PriorityUnit;
import org.eclipse.emf.henshin.model.SequentialUnit;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;

public class InvocationNameParser
extends AbstractParser {
    public InvocationNameParser() {
        super(new EAttribute[]{HenshinPackage.eINSTANCE.getNamedElement_Name()});
    }

    public String getPrintString(IAdaptable element, int flags) {
        TransformationUnit invocation = (TransformationUnit)element.getAdapter(EObject.class);
        if (invocation == null || invocation.getName() == null) {
            return "null";
        }
        String result = invocation.getName();
        if (!invocation.getParameters().isEmpty() && element.getAdapter(View.class) != null) {
            View view = (View)element.getAdapter(View.class);
            View invocationView = (View)view.eContainer();
            View compartmentView = (View)invocationView.eContainer();
            View unitView = (View)compartmentView.eContainer();
            TransformationUnit unit = (TransformationUnit)unitView.getElement();
            result = String.valueOf(result) + "(";
            boolean first = true;
            for (Parameter param1 : invocation.getParameters()) {
                boolean found1 = false;
                boolean found2 = false;
                Parameter param2 = null;
                for (ParameterMapping m : unit.getParameterMappings()) {
                    if (m.getSource() == param1 && m.getTarget() != null && m.getTarget().getUnit() == unit) {
                        found1 = true;
                        param2 = m.getTarget();
                    }
                    if (m.getTarget() != param1 || m.getSource() == null || m.getSource().getUnit() != unit) continue;
                    found2 = true;
                    param2 = m.getSource();
                }
                if (!first) {
                    result = String.valueOf(result) + ", ";
                }
                result = found1 || found2 ? String.valueOf(result) + param2.getName() : String.valueOf(result) + "?";
                first = false;
            }
            result = String.valueOf(result) + ")";
        }
        return result;
    }

    public String getEditString(IAdaptable element, int flags) {
        return this.getPrintString(element, flags);
    }

    public ICommand getParseCommand(IAdaptable element, final String value, int flags) {
        final View view = (View)element.getAdapter(View.class);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)view.getElement());
        if (domain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(domain, "Parse Invocation Name", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return InvocationNameParser.this.doParsing(view, value);
            }
        };
        return command;
    }

    protected CommandResult doParsing(View nameView, String value) throws ExecutionException {
        String[] parsed = this.parseNameAndParams(value);
        View invocationView = (View)nameView.eContainer();
        View compartmentView = (View)invocationView.eContainer();
        View unitView = (View)compartmentView.eContainer();
        TransformationUnit unit = (TransformationUnit)unitView.getElement();
        int position = UnitEditHelper.getInvocationViews(unitView, true).indexOf(invocationView);
        if (position < 0) {
            return CommandResult.newErrorCommandResult((String)"Error locating position of invocation");
        }
        TransformationSystem system = (TransformationSystem)nameView.getDiagram().getElement();
        ArrayList candidates = new ArrayList();
        candidates.addAll(system.getRules());
        candidates.addAll(system.getTransformationUnits());
        for (TransformationUnit target : candidates) {
            if (!parsed[0].equals(target.getName())) continue;
            if (unit instanceof SequentialUnit) {
                ((SequentialUnit)unit).getSubUnits().set(position, (Object)target);
            } else if (unit instanceof PriorityUnit) {
                ((PriorityUnit)unit).getSubUnits().set(position, (Object)target);
            } else if (unit instanceof IndependentUnit) {
                ((IndependentUnit)unit).getSubUnits().set(position, (Object)target);
            } else if (unit instanceof LoopUnit) {
                ((LoopUnit)unit).setSubUnit(target);
            } else if (unit instanceof IteratedUnit) {
                ((IteratedUnit)unit).setSubUnit(target);
            } else if (unit instanceof ConditionalUnit) {
                if (invocationView == UnitEditHelper.getInvocationView(unitView, UnitEditHelper.InvocationViewKey.IF)) {
                    ((ConditionalUnit)unit).setIf(target);
                } else if (invocationView == UnitEditHelper.getInvocationView(unitView, UnitEditHelper.InvocationViewKey.THEN)) {
                    ((ConditionalUnit)unit).setThen(target);
                } else if (invocationView == UnitEditHelper.getInvocationView(unitView, UnitEditHelper.InvocationViewKey.ELSE)) {
                    ((ConditionalUnit)unit).setElse(target);
                }
            } else {
                return CommandResult.newErrorCommandResult((String)("Unknown transformation unit type: " + unit.eClass().getName()));
            }
            invocationView.setElement((EObject)target);
            nameView.setElement((EObject)target);
            int i = 1;
            while (i < parsed.length) {
                ParameterMapping mapping;
                if (target.getParameters().size() <= i - 1) break;
                Parameter targetParam = (Parameter)target.getParameters().get(i - 1);
                Iterator mappings = unit.getParameterMappings().iterator();
                while (mappings.hasNext()) {
                    mapping = (ParameterMapping)mappings.next();
                    if (mapping.getSource() != targetParam && mapping.getTarget() != targetParam) continue;
                    mappings.remove();
                }
                Parameter unitParam = unit.getParameterByName(parsed[i]);
                if (unitParam != null) {
                    mapping = HenshinFactory.eINSTANCE.createParameterMapping();
                    mapping.setSource(unitParam);
                    mapping.setTarget(targetParam);
                    unit.getParameterMappings().add((Object)mapping);
                    mapping = HenshinFactory.eINSTANCE.createParameterMapping();
                    mapping.setSource(targetParam);
                    mapping.setTarget(unitParam);
                    unit.getParameterMappings().add((Object)mapping);
                }
                ++i;
            }
            Iterator mappings = unit.getParameterMappings().iterator();
            while (mappings.hasNext()) {
                ParameterMapping mapping = (ParameterMapping)mappings.next();
                if (mapping.getSource().getUnit() != null && mapping.getTarget().getUnit() != null) continue;
                mappings.remove();
            }
            return CommandResult.newOKCommandResult();
        }
        return CommandResult.newErrorCommandResult((String)("Unknown transformation unit: " + value));
    }

    private String[] parseNameAndParams(String value) throws ExecutionException {
        String[] params;
        String name;
        int openParen = value.indexOf(40);
        if (openParen >= 0) {
            int closeParen = value.indexOf(41);
            if (closeParen < openParen) {
                throw new ExecutionException("Syntax error");
            }
            name = value.substring(0, openParen);
            params = value.substring(openParen + 1, closeParen).split(",");
            int i = 0;
            while (i < params.length) {
                params[i] = params[i].trim();
                ++i;
            }
        } else {
            name = value.trim();
            params = new String[]{};
        }
        String[] result = new String[params.length + 1];
        result[0] = name;
        System.arraycopy(params, 0, result, 1, params.length);
        return result;
    }

    @Override
    protected boolean isAffectingFeature(Object feature) {
        if (feature == HenshinPackage.eINSTANCE.getNamedElement_Name()) {
            return true;
        }
        if (feature == HenshinPackage.eINSTANCE.getTransformationUnit_Parameters()) {
            return true;
        }
        if (feature == EcorePackage.eINSTANCE.getEModelElement_EAnnotations()) {
            return true;
        }
        return feature == EcorePackage.eINSTANCE.getEAnnotation_References();
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }
}

