/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.henshin.model.And;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.AttributeCondition;
import org.eclipse.emf.henshin.model.ConditionalUnit;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.IndependentUnit;
import org.eclipse.emf.henshin.model.IteratedUnit;
import org.eclipse.emf.henshin.model.LoopUnit;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Not;
import org.eclipse.emf.henshin.model.Or;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterMapping;
import org.eclipse.emf.henshin.model.PriorityUnit;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.SequentialUnit;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.Xor;
import org.eclipse.emf.henshin.model.impl.AndImpl;
import org.eclipse.emf.henshin.model.impl.AttributeConditionImpl;
import org.eclipse.emf.henshin.model.impl.AttributeImpl;
import org.eclipse.emf.henshin.model.impl.ConditionalUnitImpl;
import org.eclipse.emf.henshin.model.impl.EdgeImpl;
import org.eclipse.emf.henshin.model.impl.GraphImpl;
import org.eclipse.emf.henshin.model.impl.IndependentUnitImpl;
import org.eclipse.emf.henshin.model.impl.IteratedUnitImpl;
import org.eclipse.emf.henshin.model.impl.LoopUnitImpl;
import org.eclipse.emf.henshin.model.impl.MappingImpl;
import org.eclipse.emf.henshin.model.impl.NestedConditionImpl;
import org.eclipse.emf.henshin.model.impl.NodeImpl;
import org.eclipse.emf.henshin.model.impl.NotImpl;
import org.eclipse.emf.henshin.model.impl.OrImpl;
import org.eclipse.emf.henshin.model.impl.ParameterImpl;
import org.eclipse.emf.henshin.model.impl.ParameterMappingImpl;
import org.eclipse.emf.henshin.model.impl.PriorityUnitImpl;
import org.eclipse.emf.henshin.model.impl.RuleImpl;
import org.eclipse.emf.henshin.model.impl.SequentialUnitImpl;
import org.eclipse.emf.henshin.model.impl.TransformationSystemImpl;
import org.eclipse.emf.henshin.model.impl.XorImpl;

public class HenshinFactoryImpl
extends EFactoryImpl
implements HenshinFactory {
    public static final String DEFAULT_RULE_LHS_NAME = "LHS";
    public static final String DEFAULT_RULE_RHS_NAME = "RHS";

    public static HenshinFactory init() {
        try {
            HenshinFactory theHenshinFactory = (HenshinFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/emf/2011/Henshin");
            if (theHenshinFactory != null) {
                return theHenshinFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new HenshinFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 2: {
                return this.createTransformationSystem();
            }
            case 3: {
                return this.createRule();
            }
            case 4: {
                return this.createAttributeCondition();
            }
            case 5: {
                return this.createParameter();
            }
            case 6: {
                return this.createGraph();
            }
            case 8: {
                return this.createMapping();
            }
            case 9: {
                return this.createNode();
            }
            case 10: {
                return this.createAttribute();
            }
            case 11: {
                return this.createEdge();
            }
            case 13: {
                return this.createIndependentUnit();
            }
            case 14: {
                return this.createSequentialUnit();
            }
            case 15: {
                return this.createConditionalUnit();
            }
            case 16: {
                return this.createPriorityUnit();
            }
            case 17: {
                return this.createIteratedUnit();
            }
            case 18: {
                return this.createLoopUnit();
            }
            case 19: {
                return this.createNestedCondition();
            }
            case 23: {
                return this.createAnd();
            }
            case 24: {
                return this.createOr();
            }
            case 25: {
                return this.createXor();
            }
            case 26: {
                return this.createNot();
            }
            case 27: {
                return this.createParameterMapping();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    @Override
    public TransformationSystem createTransformationSystem() {
        TransformationSystemImpl transformationSystem = new TransformationSystemImpl();
        return transformationSystem;
    }

    @Override
    public Rule createRule() {
        RuleImpl rule = new RuleImpl();
        Graph lhs = this.createGraph();
        lhs.setName(DEFAULT_RULE_LHS_NAME);
        rule.setLhs(lhs);
        Graph rhs = this.createGraph();
        rhs.setName(DEFAULT_RULE_RHS_NAME);
        rule.setRhs(rhs);
        return rule;
    }

    @Override
    public AttributeCondition createAttributeCondition() {
        AttributeConditionImpl attributeCondition = new AttributeConditionImpl();
        return attributeCondition;
    }

    @Override
    public Parameter createParameter() {
        ParameterImpl parameter = new ParameterImpl();
        return parameter;
    }

    public Parameter createParameter(String name) {
        ParameterImpl parameter = new ParameterImpl();
        parameter.setName(name);
        return parameter;
    }

    @Override
    public Graph createGraph() {
        GraphImpl graph = new GraphImpl();
        return graph;
    }

    @Override
    public Mapping createMapping() {
        MappingImpl mapping = new MappingImpl();
        return mapping;
    }

    @Override
    public Mapping createMapping(Node origin, Node image) {
        Mapping mapping = this.createMapping();
        mapping.setOrigin(origin);
        mapping.setImage(image);
        return mapping;
    }

    @Override
    public Node createNode() {
        NodeImpl node = new NodeImpl();
        return node;
    }

    @Override
    public Node createNode(Graph graph, EClass type) {
        Node node = this.createNode();
        node.setType(type);
        graph.getNodes().add((Object)node);
        return node;
    }

    @Override
    public Attribute createAttribute() {
        AttributeImpl attribute = new AttributeImpl();
        return attribute;
    }

    @Override
    public Attribute createAttribute(Node node, EAttribute type, String value) {
        Attribute attribute = this.createAttribute();
        attribute.setNode(node);
        attribute.setType(type);
        attribute.setValue(value);
        return attribute;
    }

    @Override
    public Edge createEdge() {
        EdgeImpl edge = new EdgeImpl();
        return edge;
    }

    @Override
    public Edge createEdge(Node source, Node target, EReference type) {
        Edge edge = this.createEdge();
        edge.setSource(source);
        edge.setTarget(target);
        edge.setType(type);
        edge.setGraph(source.getGraph());
        return edge;
    }

    @Override
    public IndependentUnit createIndependentUnit() {
        IndependentUnitImpl independentUnit = new IndependentUnitImpl();
        return independentUnit;
    }

    @Override
    public SequentialUnit createSequentialUnit() {
        SequentialUnitImpl sequentialUnit = new SequentialUnitImpl();
        return sequentialUnit;
    }

    @Override
    public ConditionalUnit createConditionalUnit() {
        ConditionalUnitImpl conditionalUnit = new ConditionalUnitImpl();
        return conditionalUnit;
    }

    @Override
    public PriorityUnit createPriorityUnit() {
        PriorityUnitImpl priorityUnit = new PriorityUnitImpl();
        return priorityUnit;
    }

    @Override
    public IteratedUnit createIteratedUnit() {
        IteratedUnitImpl iteratedUnit = new IteratedUnitImpl();
        return iteratedUnit;
    }

    @Override
    public LoopUnit createLoopUnit() {
        LoopUnitImpl loopUnit = new LoopUnitImpl();
        return loopUnit;
    }

    @Override
    public NestedCondition createNestedCondition() {
        NestedConditionImpl nestedCondition = new NestedConditionImpl();
        return nestedCondition;
    }

    @Override
    public And createAnd() {
        AndImpl and = new AndImpl();
        return and;
    }

    @Override
    public Or createOr() {
        OrImpl or = new OrImpl();
        return or;
    }

    @Override
    public Not createNot() {
        NotImpl not = new NotImpl();
        return not;
    }

    @Override
    public Xor createXor() {
        XorImpl xor = new XorImpl();
        return xor;
    }

    @Override
    public ParameterMapping createParameterMapping() {
        ParameterMappingImpl parameterMapping = new ParameterMappingImpl();
        return parameterMapping;
    }

    @Override
    public HenshinPackage getHenshinPackage() {
        return (HenshinPackage)this.getEPackage();
    }

    @Deprecated
    public static HenshinPackage getPackage() {
        return HenshinPackage.eINSTANCE;
    }
}

