/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.impl.NamedElementImpl;

public class NodeImpl
extends NamedElementImpl
implements Node {
    protected EClass type;
    protected EList<Attribute> attributes;
    protected EList<Edge> incoming;
    protected EList<Edge> outgoing;

    protected NodeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return HenshinPackage.Literals.NODE;
    }

    @Override
    public EClass getType() {
        if (this.type != null && this.type.eIsProxy()) {
            InternalEObject oldType = (InternalEObject)this.type;
            this.type = (EClass)this.eResolveProxy(oldType);
            if (this.type != oldType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 1, (Object)oldType, (Object)this.type));
            }
        }
        return this.type;
    }

    public EClass basicGetType() {
        return this.type;
    }

    @Override
    public void setType(EClass newType) {
        EClass oldType = this.type;
        this.type = newType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldType, (Object)this.type));
        }
    }

    @Override
    public EList<Attribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new EObjectContainmentWithInverseEList(Attribute.class, (InternalEObject)this, 2, 2);
        }
        return this.attributes;
    }

    @Override
    public Graph getGraph() {
        if (this.eContainerFeatureID() != 3) {
            return null;
        }
        return (Graph)this.eContainer();
    }

    public NotificationChain basicSetGraph(Graph newGraph, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newGraph, 3, msgs);
        return msgs;
    }

    @Override
    public void setGraph(Graph newGraph) {
        if (newGraph != this.eInternalContainer() || this.eContainerFeatureID() != 3 && newGraph != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newGraph)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newGraph != null) {
                msgs = ((InternalEObject)newGraph).eInverseAdd((InternalEObject)this, 1, Graph.class, msgs);
            }
            if ((msgs = this.basicSetGraph(newGraph, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newGraph, (Object)newGraph));
        }
    }

    @Override
    public EList<Edge> getIncoming() {
        if (this.incoming == null) {
            this.incoming = new EObjectWithInverseResolvingEList(Edge.class, (InternalEObject)this, 4, 1);
        }
        return this.incoming;
    }

    @Override
    public EList<Edge> getOutgoing() {
        if (this.outgoing == null) {
            this.outgoing = new EObjectWithInverseResolvingEList(Edge.class, (InternalEObject)this, 5, 0);
        }
        return this.outgoing;
    }

    @Override
    public EList<Edge> getAllEdges() {
        ArrayList<Edge> allEdges = new ArrayList<Edge>();
        allEdges.addAll((Collection<Edge>)this.getIncoming());
        allEdges.addAll((Collection<Edge>)this.getOutgoing());
        return new EcoreEList.UnmodifiableEList((InternalEObject)this, (EStructuralFeature)HenshinPackage.Literals.NODE__ALL_EDGES, allEdges.size(), allEdges.toArray());
    }

    @Override
    public EList<Edge> findOutgoingEdgesByType(EReference edgeType) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge edge : this.getOutgoing()) {
            if (edgeType != edge.getType()) continue;
            edges.add(edge);
        }
        return new BasicEList.UnmodifiableEList(edges.size(), edges.toArray());
    }

    @Override
    public EList<Edge> findIncomingEdgesByType(EReference edgeType) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge edge : this.getIncoming()) {
            if (edgeType != edge.getType()) continue;
            edges.add(edge);
        }
        return new BasicEList.UnmodifiableEList(edges.size(), edges.toArray());
    }

    @Override
    public Attribute findAttributeByType(EAttribute attributeType) {
        for (Attribute attribute : this.getAttributes()) {
            if (attribute.getType() != attributeType) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public Edge findOutgoingEdgeByType(Node targetNode, EReference edgeType) {
        for (Edge edge : this.getOutgoing()) {
            if (edgeType != edge.getType() || targetNode != edge.getTarget()) continue;
            return edge;
        }
        return null;
    }

    @Override
    public Edge findIncomingEdgeByType(Node sourceNode, EReference edgeType) {
        for (Edge edge : this.getIncoming()) {
            if (edgeType != edge.getType() || sourceNode != edge.getSource()) continue;
            return edge;
        }
        return null;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getAttributes()).basicAdd((Object)otherEnd, msgs);
            }
            case 3: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetGraph((Graph)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getIncoming()).basicAdd((Object)otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getOutgoing()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getAttributes()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return this.basicSetGraph(null, msgs);
            }
            case 4: {
                return ((InternalEList)this.getIncoming()).basicRemove((Object)otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getOutgoing()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 3: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 1, Graph.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                if (resolve) {
                    return this.getType();
                }
                return this.basicGetType();
            }
            case 2: {
                return this.getAttributes();
            }
            case 3: {
                return this.getGraph();
            }
            case 4: {
                return this.getIncoming();
            }
            case 5: {
                return this.getOutgoing();
            }
            case 6: {
                return this.getAllEdges();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setType((EClass)newValue);
                return;
            }
            case 2: {
                this.getAttributes().clear();
                this.getAttributes().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setGraph((Graph)newValue);
                return;
            }
            case 4: {
                this.getIncoming().clear();
                this.getIncoming().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getOutgoing().clear();
                this.getOutgoing().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setType(null);
                return;
            }
            case 2: {
                this.getAttributes().clear();
                return;
            }
            case 3: {
                this.setGraph(null);
                return;
            }
            case 4: {
                this.getIncoming().clear();
                return;
            }
            case 5: {
                this.getOutgoing().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.type != null;
            }
            case 2: {
                return this.attributes != null && !this.attributes.isEmpty();
            }
            case 3: {
                return this.getGraph() != null;
            }
            case 4: {
                return this.incoming != null && !this.incoming.isEmpty();
            }
            case 5: {
                return this.outgoing != null && !this.outgoing.isEmpty();
            }
            case 6: {
                return !this.getAllEdges().isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }
}

